package com.bcxin.tenant.bcx.jdks;

import com.bcxin.tenant.bcx.infrastructures.EntityCollection;
import com.bcxin.tenant.bcx.jdks.requests.organregistry.OrganRegistryFormsRequest;
import com.bcxin.tenant.bcx.jdks.requests.organregistry.OrganRegistryFormsSearchRequest;
import com.bcxin.tenant.bcx.jdks.responses.organregistry.OrganRegistryFormsResponse;

import java.util.List;

/**
 * 企业注册表单RPC提供者接口
 */
public interface OrganRegistryFormsRpcProvider {
    /**
     * 创建企业注册表单
     */
    void create(OrganRegistryFormsRequest request);

    /**
     * 更新企业注册表单
     */
    void update(String id, OrganRegistryFormsRequest request);

    /**
     * 删除企业注册表单
     */
    void delete(String id);

    /**
     * 批量删除企业注册表单（逻辑删除）
     */
    void batchDelete(List<String> ids);

    /**
     * 搜索企业注册表单
     */
    EntityCollection<OrganRegistryFormsResponse> search(OrganRegistryFormsSearchRequest request);

    /**
     * 根据ID获取企业注册表单
     */
    OrganRegistryFormsResponse getById(String id);

    /**
     * 根据条件查找企业注册表单
     * @param institutionalTypeCode 机构类型编码
     * @param industryTypeCode 行业类型编码
     * @param regionCode 监管区域编码
     * @return 匹配的企业注册表单，如果不存在返回null
     */
    OrganRegistryFormsResponse findByCondition(String institutionalTypeCode, String industryTypeCode, String regionCode);
}
