package com.bcxin.tenant.bcx.infrastructures.utils;

import com.bcxin.tenant.bcx.infrastructures.components.JsonProvider;
import com.bcxin.tenant.bcx.infrastructures.valueTypes.StationCodeValueType;
import com.bcxin.tenant.bcx.infrastructures.valueTypes.StationTypeMapValueType;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class StationCodeUtils {
    private static Collection<StationCodeValueType> _stationCodeValues;

    public static Collection<StationCodeValueType> getStationCodeValues() {
        if (_stationCodeValues == null) {
            String options = "[\n" +
                    "  {\n" +
                    "    \"code\": \"01\",\n" +
                    "    \"name\": \"党政机关\",\n" +
                    "    \"icon\": \"https://bcxin-static.obs.myhuaweicloud.com/v5/station-typesIcon/%E5%85%9A%E6%94%BF%E6%9C%BA%E5%85%B3%402x.png\",\n" +
                    "    \"mapIcon\": \"https://bcxin-static.obs.cn-north-1.myhuaweicloud.com/v5/station-typesMapIcon/%E5%85%9A%E6%94%BF%E6%9C%BA%E5%85%B3%402x.png\"\n" +
                    "  },\n" +
                    "  {\n" +
                    "    \"code\": \"02\",\n" +
                    "    \"name\": \"中学（公立）\",\n" +
                    "    \"icon\": \"https://bcxin-static.obs.myhuaweicloud.com/v5/station-typesIcon/%E4%B8%AD%E5%AD%A6%EF%BC%88%E5%85%AC%E7%AB%8B%EF%BC%89%402x.png\",\n" +
                    "    \"mapIcon\": \"https://bcxin-static.obs.cn-north-1.myhuaweicloud.com/v5/station-typesMapIcon/%E4%B8%AD%E5%AD%A6%EF%BC%88%E5%85%AC%E7%AB%8B%EF%BC%89%402x.png\"\n" +
                    "  },\n" +
                    "  {\n" +
                    "    \"code\": \"22\",\n" +
                    "    \"name\": \"中学（私立）\",\n" +
                    "    \"icon\": \"https://bcxin-static.obs.myhuaweicloud.com/v5/station-typesIcon/%E4%B8%AD%E5%AD%A6%EF%BC%88%E7%A7%81%E7%AB%8B%EF%BC%89%402x.png\",\n" +
                    "    \"mapIcon\": \"https://bcxin-static.obs.cn-north-1.myhuaweicloud.com/v5/station-typesMapIcon/%E4%B8%AD%E5%AD%A6%EF%BC%88%E7%A7%81%E7%AB%8B%EF%BC%89%402x.png\"\n" +
                    "  },\n" +
                    "  {\n" +
                    "    \"code\": \"03\",\n" +
                    "    \"name\": \"小学（公立）\",\n" +
                    "    \"icon\": \"https://bcxin-static.obs.myhuaweicloud.com/v5/station-typesIcon/%E5%B0%8F%E5%AD%A6%EF%BC%88%E5%85%AC%E7%AB%8B%EF%BC%89%402x.png\",\n" +
                    "    \"mapIcon\": \"https://bcxin-static.obs.cn-north-1.myhuaweicloud.com/v5/station-typesMapIcon/%E5%B0%8F%E5%AD%A6%EF%BC%88%E5%85%AC%E7%AB%8B%29%402x.png\"\n" +
                    "  },\n" +
                    "  {\n" +
                    "    \"code\": \"23\",\n" +
                    "    \"name\": \"小学（私立）\",\n" +
                    "    \"icon\": \"https://bcxin-static.obs.myhuaweicloud.com/v5/station-typesIcon/%E5%B0%8F%E5%AD%A6%EF%BC%88%E7%A7%81%E7%AB%8B%EF%BC%89%402x.png\",\n" +
                    "    \"mapIcon\": \"https://bcxin-static.obs.cn-north-1.myhuaweicloud.com/v5/station-typesMapIcon/%E5%B0%8F%E5%AD%A6%EF%BC%88%E7%A7%81%E7%AB%8B%29%402x.png\"\n" +
                    "  },\n" +
                    "  {\n" +
                    "    \"code\": \"04\",\n" +
                    "    \"name\": \"幼儿园（公立）\",\n" +
                    "    \"icon\": \"https://bcxin-static.obs.myhuaweicloud.com/v5/station-typesIcon/%E5%B9%BC%E5%84%BF%E5%9B%AD%EF%BC%88%E5%85%AC%E7%AB%8B%EF%BC%89%402x.png\",\n" +
                    "    \"mapIcon\": \"https://bcxin-static.obs.cn-north-1.myhuaweicloud.com/v5/station-typesMapIcon/%E5%B9%BC%E5%84%BF%E5%9B%AD%EF%BC%88%E5%85%AC%E7%AB%8B%29%402x.png\"\n" +
                    "  },\n" +
                    "  {\n" +
                    "    \"code\": \"24\",\n" +
                    "    \"name\": \"幼儿园（私立）\",\n" +
                    "    \"icon\": \"https://bcxin-static.obs.myhuaweicloud.com/v5/station-typesIcon/%E5%B9%BC%E5%84%BF%E5%9B%AD%EF%BC%88%E7%A7%81%E7%AB%8B%EF%BC%89%402x.png\",\n" +
                    "    \"mapIcon\": \"https://bcxin-static.obs.cn-north-1.myhuaweicloud.com/v5/station-typesMapIcon/%E5%B9%BC%E5%84%BF%E5%9B%AD%EF%BC%88%E7%A7%81%E7%AB%8B%29%402x.png\"\n" +
                    "  },\n" +
                    "  {\n" +
                    "    \"code\": \"05\",\n" +
                    "    \"name\": \"医疗机构（一级）\",\n" +
                    "    \"icon\": \"https://bcxin-static.obs.myhuaweicloud.com/v5/station-typesIcon/%E5%8C%BB%E7%96%97%E6%9C%BA%E6%9E%84%EF%BC%88%E4%B8%80%E7%BA%A7%EF%BC%89%402x.png\",\n" +
                    "    \"mapIcon\": \"https://bcxin-static.obs.cn-north-1.myhuaweicloud.com/v5/station-typesMapIcon/%E5%8C%BB%E7%96%97%E6%9C%BA%E6%9E%84%EF%BC%88%E4%B8%80%E7%BA%A7%29%402x.png\"\n" +
                    "  },\n" +
                    "  {\n" +
                    "    \"code\": \"25\",\n" +
                    "    \"name\": \"医疗机构（二级）\",\n" +
                    "    \"icon\": \"https://bcxin-static.obs.myhuaweicloud.com/v5/station-typesIcon/%E5%8C%BB%E7%96%97%E6%9C%BA%E6%9E%84%EF%BC%88%E4%BA%8C%E7%BA%A7%EF%BC%89%402x.png\",\n" +
                    "    \"mapIcon\": \"https://bcxin-static.obs.cn-north-1.myhuaweicloud.com/v5/station-typesMapIcon/%E5%8C%BB%E7%96%97%E6%9C%BA%E6%9E%84%EF%BC%88%E4%B8%89%E7%BA%A7%29%402x.png\"\n" +
                    "  },\n" +
                    "  {\n" +
                    "    \"code\": \"26\",\n" +
                    "    \"name\": \"医疗机构（三级）\",\n" +
                    "    \"icon\": \"https://bcxin-static.obs.myhuaweicloud.com/v5/station-typesIcon/%E5%8C%BB%E7%96%97%E6%9C%BA%E6%9E%84%EF%BC%88%E4%B8%89%E7%BA%A7%EF%BC%89%402x.png\",\n" +
                    "    \"mapIcon\": \"https://bcxin-static.obs.cn-north-1.myhuaweicloud.com/v5/station-typesMapIcon/%E5%8C%BB%E7%96%97%E6%9C%BA%E6%9E%84%EF%BC%88%E4%BA%8C%E7%BA%A7%29%402x.png\"\n" +
                    "  },\n" +
                    "  {\n" +
                    "    \"code\": \"06\",\n" +
                    "    \"name\": \"高等院校\",\n" +
                    "    \"icon\": \"https://bcxin-static.obs.myhuaweicloud.com/v5/station-typesIcon/%E9%AB%98%E7%AD%89%E9%99%A2%E6%A0%A1%402x.png\",\n" +
                    "    \"mapIcon\": \"https://bcxin-static.obs.cn-north-1.myhuaweicloud.com/v5/station-typesMapIcon/%E9%AB%98%E7%AD%89%E9%99%A2%E6%A0%A1%402x.png\"\n" +
                    "  },\n" +
                    "  {\n" +
                    "    \"code\": \"07\",\n" +
                    "    \"name\": \"公交安全\",\n" +
                    "    \"icon\": \"https://bcxin-static.obs.myhuaweicloud.com/v5/station-typesIcon/%E5%85%AC%E5%85%B1%E5%AE%89%E5%85%A8%402x.png\",\n" +
                    "    \"mapIcon\": \"https://bcxin-static.obs.cn-north-1.myhuaweicloud.com/v5/station-typesMapIcon/%E5%85%AC%E5%85%B1%E5%AE%89%E5%85%A8%402x.png\"\n" +
                    "  },\n" +
                    "  {\n" +
                    "    \"code\": \"08\",\n" +
                    "    \"name\": \"轨道交通\",\n" +
                    "    \"icon\": \"https://bcxin-static.obs.myhuaweicloud.com/v5/station-typesIcon/%E8%BD%A8%E9%81%93%E4%BA%A4%E9%80%9A%402x.png\",\n" +
                    "    \"mapIcon\": \"https://bcxin-static.obs.cn-north-1.myhuaweicloud.com/v5/station-typesMapIcon/%E8%BD%A8%E9%81%93%E4%BA%A4%E9%80%9A%402x.png\"\n" +
                    "  },\n" +
                    "  {\n" +
                    "    \"code\": \"09\",\n" +
                    "    \"name\": \"娱乐场所\",\n" +
                    "    \"icon\": \"https://bcxin-static.obs.myhuaweicloud.com/v5/station-typesIcon/%E5%A8%B1%E4%B9%90%E5%9C%BA%E6%89%80%402x.png\",\n" +
                    "    \"mapIcon\": \"https://bcxin-static.obs.cn-north-1.myhuaweicloud.com/v5/station-typesMapIcon/%E5%A8%B1%E4%B9%90%E5%9C%BA%E6%89%80%402x.png\"\n" +
                    "  },\n" +
                    "  {\n" +
                    "    \"code\": \"10\",\n" +
                    "    \"name\": \"金融网点（银行）\",\n" +
                    "    \"icon\": \"https://bcxin-static.obs.myhuaweicloud.com/v5/station-typesIcon/%E9%87%91%E8%9E%8D%E7%BD%91%E7%82%B9%EF%BC%88%E9%93%B6%E8%A1%8C%EF%BC%89%402x.png\",\n" +
                    "    \"mapIcon\": \"https://bcxin-static.obs.cn-north-1.myhuaweicloud.com/v5/station-typesMapIcon/%E9%87%91%E8%9E%8D%E7%BD%91%E7%82%B9%28%E9%93%B6%E8%A1%8C%29%402x.png\"\n" +
                    "  },\n" +
                    "  {\n" +
                    "    \"code\": \"27\",\n" +
                    "    \"name\": \"金融网点（证券）\",\n" +
                    "    \"icon\": \"https://bcxin-static.obs.myhuaweicloud.com/v5/station-typesIcon/%E9%87%91%E8%9E%8D%E7%BD%91%E7%82%B9%EF%BC%88%E8%AF%81%E5%88%B8%EF%BC%89%402x.png\",\n" +
                    "    \"mapIcon\": \"https://bcxin-static.obs.cn-north-1.myhuaweicloud.com/v5/station-typesMapIcon/%E9%87%91%E8%9E%8D%E7%BD%91%E7%82%B9%28%E8%AF%81%E5%88%B8%29%402x.png\"\n" +
                    "  },\n" +
                    "  {\n" +
                    "    \"code\": \"11\",\n" +
                    "    \"name\": \"酒店餐饮\",\n" +
                    "    \"icon\": \"https://bcxin-static.obs.myhuaweicloud.com/v5/station-typesIcon/%E9%85%92%E5%BA%97%E9%A4%90%E9%A5%AE%402x.png\",\n" +
                    "    \"mapIcon\": \"https://bcxin-static.obs.cn-north-1.myhuaweicloud.com/v5/station-typesMapIcon/%E9%85%92%E5%BA%97%E9%A4%90%E9%A5%AE%402x.png\"\n" +
                    "  },\n" +
                    "  {\n" +
                    "    \"code\": \"12\",\n" +
                    "    \"name\": \"商市场\",\n" +
                    "    \"icon\": \"https://bcxin-static.obs.myhuaweicloud.com/v5/station-typesIcon/%E5%95%86%E5%B8%82%E5%9C%BA%402x.png\",\n" +
                    "    \"mapIcon\": \"https://bcxin-static.obs.cn-north-1.myhuaweicloud.com/v5/station-typesMapIcon/%E5%95%86%E5%B8%82%E5%9C%BA%402x.png\"\n" +
                    "  },\n" +
                    "  {\n" +
                    "    \"code\": \"13\",\n" +
                    "    \"name\": \"写字楼\",\n" +
                    "    \"icon\": \"https://bcxin-static.obs.myhuaweicloud.com/v5/station-typesIcon/%E5%86%99%E5%AD%97%E6%A5%BC%402x.png\",\n" +
                    "    \"mapIcon\": \"https://bcxin-static.obs.cn-north-1.myhuaweicloud.com/v5/station-typesMapIcon/%E5%86%99%E5%AD%97%E6%A5%BC%402x.png\"\n" +
                    "  },\n" +
                    "  {\n" +
                    "    \"code\": \"14\",\n" +
                    "    \"name\": \"公园景区\",\n" +
                    "    \"icon\": \"https://bcxin-static.obs.myhuaweicloud.com/v5/station-typesIcon/%E5%85%AC%E5%9B%AD%E6%99%AF%E5%8C%BA%402x.png\",\n" +
                    "    \"mapIcon\": \"https://bcxin-static.obs.cn-north-1.myhuaweicloud.com/v5/station-typesMapIcon/%E5%85%AC%E5%9B%AD%E6%99%AF%E5%8C%BA%402x.png\"\n" +
                    "  },\n" +
                    "  {\n" +
                    "    \"code\": \"15\",\n" +
                    "    \"name\": \"园区\",\n" +
                    "    \"icon\": \"https://bcxin-static.obs.myhuaweicloud.com/v5/station-typesIcon/%E5%9B%AD%E5%8C%BA%402x.png\",\n" +
                    "    \"mapIcon\": \"https://bcxin-static.obs.cn-north-1.myhuaweicloud.com/v5/station-typesMapIcon/%E5%9B%AD%E5%8C%BA%402x.png\"\n" +
                    "  },\n" +
                    "  {\n" +
                    "    \"code\": \"16\",\n" +
                    "    \"name\": \"文化中心\",\n" +
                    "    \"icon\": \"https://bcxin-static.obs.myhuaweicloud.com/v5/station-typesIcon/%E6%96%87%E5%8C%96%E4%B8%AD%E5%BF%83%402x.png\",\n" +
                    "    \"mapIcon\": \"https://bcxin-static.obs.cn-north-1.myhuaweicloud.com/v5/station-typesMapIcon/%E6%96%87%E5%8C%96%E4%B8%AD%E5%BF%83%402x.png\"\n" +
                    "  },\n" +
                    "  {\n" +
                    "    \"code\": \"17\",\n" +
                    "    \"name\": \"体育场馆\",\n" +
                    "    \"icon\": \"https://bcxin-static.obs.myhuaweicloud.com/v5/station-typesIcon/%E4%BD%93%E8%82%B2%E5%9C%BA%E9%A6%86%402x.png\",\n" +
                    "    \"mapIcon\": \"https://bcxin-static.obs.cn-north-1.myhuaweicloud.com/v5/station-typesMapIcon/%E4%BD%93%E8%82%B2%E5%9C%BA%E9%A6%86%402x.png\"\n" +
                    "  },\n" +
                    "  {\n" +
                    "    \"code\": \"18\",\n" +
                    "    \"name\": \"会展中心\",\n" +
                    "    \"icon\": \"https://bcxin-static.obs.myhuaweicloud.com/v5/station-typesIcon/%E4%BC%9A%E5%B1%95%E4%B8%AD%E5%BF%83%402x.png\",\n" +
                    "    \"mapIcon\": \"https://bcxin-static.obs.cn-north-1.myhuaweicloud.com/v5/station-typesMapIcon/%E4%BC%9A%E5%B1%95%E4%B8%AD%E5%BF%83%402x.png\"\n" +
                    "  },\n" +
                    "  {\n" +
                    "    \"code\": \"19\",\n" +
                    "    \"name\": \"企业事业单位(国企)\",\n" +
                    "    \"icon\": \"https://bcxin-static.obs.myhuaweicloud.com/v5/station-typesIcon/%E4%BC%81%E4%B8%9A%E4%BA%8B%E4%B8%9A%E5%8D%95%E4%BD%8D%28%E5%9B%BD%E4%BC%81%29%402x.png\",\n" +
                    "    \"mapIcon\": \"https://bcxin-static.obs.cn-north-1.myhuaweicloud.com/v5/station-typesMapIcon/%E4%BC%81%E4%B8%9A%E4%BA%8B%E4%B8%9A%E5%8D%95%E4%BD%8D%28%E5%9B%BD%E4%BC%81%29%402x.png\"\n" +
                    "  },\n" +
                    "  {\n" +
                    "    \"code\": \"28\",\n" +
                    "    \"name\": \"企业事业单位(央企)\",\n" +
                    "    \"icon\": \"https://bcxin-static.obs.myhuaweicloud.com/v5/station-typesIcon/%E4%BC%81%E4%B8%9A%E4%BA%8B%E4%B8%9A%E5%8D%95%E4%BD%8D%28%E5%A4%AE%E4%BC%81%29%402x.png\",\n" +
                    "    \"mapIcon\": \"https://bcxin-static.obs.cn-north-1.myhuaweicloud.com/v5/station-typesMapIcon/%E4%BC%81%E4%B8%9A%E4%BA%8B%E4%B8%9A%E5%8D%95%E4%BD%8D%28%E5%A4%AE%E4%BC%81%29%402x.png\"\n" +
                    "  },\n" +
                    "  {\n" +
                    "    \"code\": \"29\",\n" +
                    "    \"name\": \"企业事业单位(私企)\",\n" +
                    "    \"icon\": \"https://bcxin-static.obs.myhuaweicloud.com/v5/station-typesIcon/%E4%BC%81%E4%B8%9A%E4%BA%8B%E4%B8%9A%E5%8D%95%E4%BD%8D%28%E7%A7%81%E4%BC%81%29%402x.png\",\n" +
                    "    \"mapIcon\": \"https://bcxin-static.obs.cn-north-1.myhuaweicloud.com/v5/station-typesMapIcon/%E4%BC%81%E4%B8%9A%E4%BA%8B%E4%B8%9A%E5%8D%95%E4%BD%8D%28%E7%A7%81%E4%BC%81%29%402x.png\"\n" +
                    "  },\n" +
                    "  {\n" +
                    "    \"code\": \"20\",\n" +
                    "    \"name\": \"居民社区\",\n" +
                    "    \"icon\": \"https://bcxin-static.obs.myhuaweicloud.com/v5/station-typesIcon/%E5%B1%85%E6%B0%91%E7%A4%BE%E5%8C%BA%402x.png\",\n" +
                    "    \"mapIcon\": \"https://bcxin-static.obs.cn-north-1.myhuaweicloud.com/v5/station-typesMapIcon/%E5%B1%85%E6%B0%91%E7%A4%BE%E5%8C%BA%402x.png\"\n" +
                    "  },\n" +
                    "  {\n" +
                    "    \"code\": \"21\",\n" +
                    "    \"name\": \"乡镇街道\",\n" +
                    "    \"icon\": \"https://bcxin-static.obs.myhuaweicloud.com/v5/station-typesIcon/%E4%B9%A1%E9%95%87%E8%A1%97%E9%81%93%402x.png\",\n" +
                    "    \"mapIcon\": \"https://bcxin-static.obs.cn-north-1.myhuaweicloud.com/v5/station-typesMapIcon/%E4%B9%A1%E9%95%87%E8%A1%97%E9%81%93%402x.png\"\n" +
                    "  },\n" +
                    "  {\n" +
                    "    \"code\": \"30\",\n" +
                    "    \"name\": \"公交交通 （线路）\",\n" +
                    "    \"icon\": \"https://bcxin-static.obs.myhuaweicloud.com/v5/station-typesIcon/%E5%85%AC%E4%BA%A4%E4%BA%A4%E9%80%9A%28%E7%BA%BF%E8%B7%AF%29%402x.png\",\n" +
                    "    \"mapIcon\": \"https://bcxin-static.obs.cn-north-1.myhuaweicloud.com/v5/station-typesMapIcon/%E5%85%AC%E4%BA%A4%E4%BA%A4%E9%80%9A%28%E7%BA%BF%E8%B7%AF%29%402x.png\"\n" +
                    "  },\n" +
                    "  {\n" +
                    "    \"code\": \"31\",\n" +
                    "    \"name\": \"公交交通 （场站）\",\n" +
                    "    \"icon\": \"https://bcxin-static.obs.myhuaweicloud.com/v5/station-typesIcon/%E5%85%AC%E4%BA%A4%E4%BA%A4%E9%80%9A%28%E5%9C%BA%E7%AB%99%29%402x.png\",\n" +
                    "    \"mapIcon\": \"https://bcxin-static.obs.cn-north-1.myhuaweicloud.com/v5/station-typesMapIcon/%E5%85%AC%E4%BA%A4%E4%BA%A4%E9%80%9A%28%E5%9C%BA%E7%AB%99%29%402x.png\"\n" +
                    "  },\n" +
                    "  {\n" +
                    "    \"code\": \"32\",\n" +
                    "    \"name\": \"轨道交通 （地铁线路）\",\n" +
                    "    \"icon\": \"https://bcxin-static.obs.myhuaweicloud.com/v5/station-typesIcon/%E8%BD%A8%E9%81%93%E4%BA%A4%E9%80%9A%28%E5%9C%B0%E9%93%81%E7%BA%BF%E8%B7%AF%29%402x.png\",\n" +
                    "    \"mapIcon\": \"https://bcxin-static.obs.cn-north-1.myhuaweicloud.com/v5/station-typesMapIcon/%E8%BD%A8%E9%81%93%E4%BA%A4%E9%80%9A%28%E5%9C%B0%E9%93%81%E7%BA%BF%E8%B7%AF%29%402x.png\"\n" +
                    "  },\n" +
                    "  {\n" +
                    "    \"code\": \"33\",\n" +
                    "    \"name\": \"轨道交通 （地铁安检）\",\n" +
                    "    \"icon\": \"https://bcxin-static.obs.myhuaweicloud.com/v5/station-typesIcon/%E8%BD%A8%E9%81%93%E4%BA%A4%E9%80%9A%28%E5%9C%B0%E9%93%81%E5%AE%89%E6%A3%80%29%402x.png\",\n" +
                    "    \"mapIcon\": \"https://bcxin-static.obs.cn-north-1.myhuaweicloud.com/v5/station-typesMapIcon/%E8%BD%A8%E9%81%93%E4%BA%A4%E9%80%9A%28%E5%9C%B0%E9%93%81%E5%AE%89%E6%A3%80%29%402x.png\"\n" +
                    "  },\n" +
                    "  {\n" +
                    "    \"code\": \"35\",\n" +
                    "    \"name\": \"重点站区\",\n" +
                    "    \"icon\": \"https://bcxin-static.obs.myhuaweicloud.com/v5/station-typesIcon/%E9%87%8D%E7%82%B9%E7%AB%99%E5%8C%BA%402x.png\",\n" +
                    "    \"mapIcon\": \"https://bcxin-static.obs.cn-north-1.myhuaweicloud.com/v5/station-typesMapIcon/%E9%87%8D%E7%82%B9%E7%AB%99%E5%8C%BA%402x.png\"\n" +
                    "  }\n" +
                    "]";

            JsonProvider jsonProvider = new JsonProvider.DefaultJsonProvider();
            _stationCodeValues = jsonProvider.toObjects(StationCodeValueType.class, options);

            _stationCodeValues.forEach(it -> {
                it.setOnlyForStation(true);
            });
        }

        return _stationCodeValues;
    }

    public static Set<StationTypeMapValueType> getStationNames(Set<String> codes) {
        if (codes == null || codes.size() == 0) {
            return Collections.EMPTY_SET;
        }

        Collection<StationCodeValueType> stationCodeValueTypes =
                StationCodeUtils.getStationCodeValues();

        Set<StationTypeMapValueType> stationNames =
                codes.stream().map(ii -> {
                    Optional<StationTypeMapValueType> selectedOptional =
                            stationCodeValueTypes.stream()
                                    .filter(ix -> ix.getCode().equals(ii))
                                    .map(ix -> StationTypeMapValueType.create(ix.getCode(), ix.getName(), ix.getMapIcon()))
                                    .findFirst();
                    if (selectedOptional.isPresent()) {
                        return selectedOptional.get();
                    }

                    return StationTypeMapValueType.create(ii, "", "");
                }).collect(Collectors.toSet());

        return stationNames;
    }
}
