package com.bcxin.tenant.bcx.dubbo.common.configs.filters;

import com.bcxin.tenant.bcx.infrastructures.exceptions.BadTenantException;
import com.bcxin.tenant.bcx.infrastructures.exceptions.TenantExceptionAbstract;
import com.bcxin.tenant.bcx.infrastructures.utils.ExceptionUtil;
import org.apache.dubbo.common.constants.CommonConstants;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.filter.ExceptionFilter;

@Activate(group = {CommonConstants.PROVIDER})
public class GlobalExceptionFilter extends ExceptionFilter {

    @Override
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        return super.invoke(invoker, invocation);
    }

    @Override
    public void onResponse(Result appResponse, Invoker<?> invoker, Invocation invocation) {

        /**
         * 当异常为非自定义异常的时候，直接走dubbo默认的异常机制
         */
        if (appResponse.hasException()) {
            if (!ExceptionUtil.is(appResponse.getException(), TenantExceptionAbstract.class)) {
                super.onResponse(appResponse, invoker, invocation);
            } else {
                String message = appResponse.getException().getMessage();
                appResponse.setException(appResponse.getException());
                // super.onResponse(appResponse, invoker, invocation);
            }
        }

        //super.onResponse(appResponse, invoker, invocation);
    }

    @Override
    public void onError(Throwable e, Invoker<?> invoker, Invocation invocation) {
        super.onError(e, invoker, invocation);
    }
}
