package com.bcxin.tenant.bcx.domains.services.commands.organregistry;

import com.bcxin.tenant.bcx.infrastructures.commands.CommandAbstract;
import com.bcxin.tenant.bcx.infrastructures.enums.MetaCreatorReferenceType;
import com.bcxin.tenant.bcx.infrastructures.enums.PageBusinessType;
import com.bcxin.tenant.bcx.infrastructures.enums.PageType;

/**
 * 创建企业注册表单命令
 */
public class CreateOrganRegistryFormsCommand extends CommandAbstract {
    private final String id;
    private final String institutionalTypeCode;
    private final String industryTypeCode;
    private final String regionCode;
    private final String pageId;
    private final String name;
    private final String note;
    private final String formJson;
    private final String slug;
    private final String logo;
    private final PageType pageType;
    private final PageBusinessType businessType;
    private final String tableName;
    private final Boolean enableBPMFlow;
    private final Boolean enableAnonymousAccess;
    private final String settingJson;

    public CreateOrganRegistryFormsCommand(String id, String institutionalTypeCode, String industryTypeCode,
                                         String regionCode, String pageId, String name, String note, 
                                         String formJson, String slug, String logo, PageType pageType, 
                                         PageBusinessType businessType, String tableName, Boolean enableBPMFlow, Boolean enableAnonymousAccess,
                                         String settingJson) {
        this.id = id;
        this.institutionalTypeCode = institutionalTypeCode;
        this.industryTypeCode = industryTypeCode;
        this.regionCode = regionCode;
        this.pageId = pageId;
        this.name = name;
        this.note = note;
        this.formJson = formJson;
        this.slug = slug;
        this.logo = logo;
        this.pageType = pageType;
        this.businessType = businessType;
        this.tableName = tableName;
        this.enableBPMFlow = enableBPMFlow;
        this.enableAnonymousAccess = enableAnonymousAccess;
        this.settingJson = settingJson;
    }

    // 添加静态工厂方法
    public static CreateOrganRegistryFormsCommand create(String id, String institutionalTypeCode, String industryTypeCode,
                                                       String regionCode, String pageId, String name, String note,
                                                       String formJson, String slug, String logo, PageType pageType,
                                                       PageBusinessType businessType, String tableName, Boolean enableBPMFlow, Boolean enableAnonymousAccess,
                                                       String settingJson) {
        return new CreateOrganRegistryFormsCommand(id, institutionalTypeCode, industryTypeCode, regionCode, pageId, name, note,
                formJson, slug, logo, pageType, businessType, tableName, enableBPMFlow, enableAnonymousAccess,
                settingJson);
    }

    public String getId() {
        return id;
    }

    public String getInstitutionalTypeCode() {
        return institutionalTypeCode;
    }

    public String getIndustryTypeCode() {
        return industryTypeCode;
    }

    public String getRegionCode() {
        return regionCode;
    }

    public String getPageId() {
        return pageId;
    }

    public String getName() {
        return name;
    }

    public String getNote() {
        return note;
    }

    public String getFormJson() {
        return formJson;
    }

    public String getSlug() {
        return slug;
    }

    public String getLogo() {
        return logo;
    }

    public PageType getPageType() {
        return pageType;
    }

    public PageBusinessType getBusinessType() {
        return businessType;
    }

    public String getTableName() {
        return tableName;
    }

    public Boolean getEnableBPMFlow() {
        return enableBPMFlow;
    }

    public Boolean getEnableAnonymousAccess() {
        return enableAnonymousAccess;
    }

    public String getSettingJson() {
        return settingJson;
    }

    @Override
    public void validate() {
//        if (institutionalTypeCode == null || institutionalTypeCode.trim().isEmpty()) {
//            throw new IllegalArgumentException("机构类型编码不能为空");
//        }
//        if (industryTypeCode == null || industryTypeCode.trim().isEmpty()) {
//            throw new IllegalArgumentException("行业类型编码不能为空");
//        }
//        if (regionCode == null || regionCode.trim().isEmpty()) {
//            throw new IllegalArgumentException("监管区域编码不能为空");
//        }
        if (name == null || name.trim().isEmpty()) {
            throw new IllegalArgumentException("表单名称不能为空");
        }
        if (pageType == null) {
            throw new IllegalArgumentException("页面类型不能为空");
        }
        if (businessType == null) {
            throw new IllegalArgumentException("业务类型不能为空");
        }
    }
}