package com.bcxin.tenant.bcx.domains.repositories;

import com.bcxin.tenant.bcx.domains.entities.MetaPageEntity;
import com.bcxin.tenant.bcx.domains.repositories.criterias.MetaPageSearchCriteria;
import com.bcxin.tenant.bcx.infrastructures.EntityCollection;
import com.bcxin.tenant.bcx.infrastructures.repositories.RepositoryBase;

import java.sql.Timestamp;
import java.util.List;

/**
 * 页面元数据仓储接口
 */
public interface MetaPageRepository extends RepositoryBase<MetaPageEntity> {
    EntityCollection<MetaPageEntity> search(MetaPageSearchCriteria criteria);

    /**
     * 批量查询页面
     * @param ids ID列表
     * @return 页面列表
     */
    List<MetaPageEntity> getByIds(List<String> ids);

    /**
     * 批量标记为已删除
     * @param ids ID列表
     * @param updateTime 更新时间
     */
    void batchMarkAsDeleted(List<String> ids, Timestamp updateTime);
}

