package com.bcxin.tenant.bcx.domains.entities;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.tenant.bcx.infrastructures.TenantEmployeeContext;
import com.bcxin.tenant.bcx.infrastructures.entities.Aggregate;
import com.bcxin.tenant.bcx.infrastructures.entities.EntityAbstract;
import com.bcxin.tenant.bcx.infrastructures.enums.MetaCreatorReferenceType;
import com.bcxin.tenant.bcx.infrastructures.enums.PageBusinessType;
import com.bcxin.tenant.bcx.infrastructures.enums.PageType;
import lombok.Data;
import org.apache.ibatis.type.EnumOrdinalTypeHandler;
import org.apache.ibatis.type.JdbcType;

import java.sql.Timestamp;
import java.util.Date;

@Data
@TableName(value = "meta_pages",autoResultMap = true)
public class MetaPageEntity extends EntityAbstract implements Aggregate {

    @TableId(value = "id")
    private String id;

    @TableField(value = "name")
    private String name;

    /**
     * 开始时间
     */
    @TableField(value = "begin_time")
    private Date beginTime;

    /**
     * 结束时间
     */
    @TableField(value = "end_time")
    private Date endTime;

    /**
     * 附件
     */
    @TableField(value = "attachment")
    private String attachment;



    /**
     * 提交限制; 默认为-1; 不限
     */
    @TableField(value = "limited_count")
    private int limitedCount;

    /**
     * 备注
     */
    @TableField(value = "note")
    private String note;

    /**
     * 页面路径地址; 初始化后不可改
     */
    @TableField(value = "slug")
    private String slug;

    @TableField(value = "logo")
    private String logo;

    /**
     * 页面类型;不可改
     */
    @TableField(value = "page_type", jdbcType = JdbcType.TINYINT, javaType = true, typeHandler = EnumOrdinalTypeHandler.class)
    private PageType pageType;

    @TableField(value = "project_id")
    private String projectId;

    @TableField(value = "module_id")
    private String moduleId;

    /**
     * 版本号; 有提交对应的业务数据之后; 自动增加版本号
     */
    @TableField(value = "version")
    private long version;

    /**
     * 表单结构类型
     */
    @TableField(value = "form_json")
    private String formJson;

    /**
     * 表单设置结构类型
     */
    @TableField(value = "form_setting_json")
    private String formSettingJson;

    /**
     * 业务类型
     */
    @TableField(value = "business_type", jdbcType = JdbcType.TINYINT, javaType = true, typeHandler = EnumOrdinalTypeHandler.class)
    private PageBusinessType businessType;

    /**
     * 数据库-表名; 初始化后不可改; 由系统自动产生
     */
    @TableField(value = "table_name")
    private String tableName;

    /**
     * 是否启用流程
     */
    @TableField(value = "enable_bpm_flow")
    private boolean enableBPMFlow;

    /**
     * 是否启用匿名访问
     */
    @TableField(value = "enable_anonymous_access")
    private boolean enableAnonymousAccess;

    /**
     * 创造者类型: 0-平台, 1-租户, 2-用户
     */
    @TableField(value = "reference_type", jdbcType = JdbcType.TINYINT, javaType = true, typeHandler = EnumOrdinalTypeHandler.class)
    private MetaCreatorReferenceType referenceType;

    /**
     * 创建者标识(平台组织Id/租户Id/用户Id)
     */
    @TableField(value = "reference_number")
    private String referenceNumber;

    /**
     * 创作者Id
     */
    @TableField(value = "creator_id")
    private String creatorId;

    /**
     * 最后修改人Id
     */
    @TableField(value = "last_updater_id")
    private String lastUpdaterId;

    @TableField(value = "creator_name")
    private String creatorName;

    @TableField(value = "last_updater_name")
    private String lastUpdaterName;

    /**
     * 是否已删除: 0-未删除, 1-已删除
     */
    @TableField(value = "deleted")
    private boolean deleted;

    @TableField(value = "last_updated_Time")
    private Timestamp lastUpdatedTime;

    @TableField(value = "created_time")
    private Timestamp createdTime;

    @TableField(value = "sync_2_identity")
    private boolean sync2Identity;

    /**
     * 逻辑删除
     */
    public void markAsDeleted() {
        this.deleted = true;
    }

    public void changeMarkAsDeleted(TenantEmployeeContext.TenantUserModel userModel) {
        this.deleted = true;
        this.setLastUpdaterName(userModel.getName());
        this.setLastUpdaterId(userModel.getId());
        this.setLastUpdatedTime(new Timestamp(System.currentTimeMillis()));
    }

    public void change(String name, TenantEmployeeContext.TenantUserModel userModel) {
        this.setName(name);
        this.setLastUpdaterName(userModel.getName());
        this.setLastUpdaterId(userModel.getId());
    }

    public void change(String name, String note, String slug, String logo, PageType pageType, PageBusinessType businessType,
                       String tableName, Boolean enableBPMFlow, Boolean enableAnonymousAccess, boolean sync2Identity,
                       Timestamp beginTime, Timestamp endTime, String attachment, int limitedCount,
                       TenantEmployeeContext.TenantUserModel userModel) {
        this.setName(name);
        this.setNote(note);
        this.setSlug(slug);
        this.setLogo(logo);
        this.setPageType(pageType);
        this.setBusinessType(businessType);
        this.setTableName(tableName);
        this.setEnableBPMFlow(enableBPMFlow != null ? enableBPMFlow : this.isEnableBPMFlow());
        this.setEnableAnonymousAccess(enableAnonymousAccess != null ? enableAnonymousAccess : this.isEnableAnonymousAccess());
        this.setSync2Identity(sync2Identity);
        this.setBeginTime(beginTime);
        this.setEndTime(endTime);
        this.setAttachment(attachment);
        this.setLimitedCount(limitedCount);
        this.setLastUpdaterName(userModel.getName());
        this.setLastUpdaterId(userModel.getId());
        this.setLastUpdatedTime(new Timestamp(System.currentTimeMillis()));
    }

    public void change(String formJson, String formSettingJson, TenantEmployeeContext.TenantUserModel tenantUserModel) {
        this.setFormJson(formJson);
        this.setFormSettingJson(formSettingJson);
        this.setLastUpdaterName(tenantUserModel.getName());
        this.setLastUpdaterId(tenantUserModel.getId());
        this.setLastUpdatedTime(new Timestamp(System.currentTimeMillis()));
    }

    public void changeVersion(long newVersion) {
        this.setVersion(newVersion);
    }

    /**
     * 静态工厂方法，用于创建页面实体
     */
    public static MetaPageEntity create(String id,
                                       String projectId,
                                       String moduleId,
                                       String name,
                                       String note,
                                       String slug,
                                       String logo,
                                       PageType pageType,
                                       PageBusinessType businessType,
                                       String tableName,
                                       boolean enableBPMFlow,
                                       boolean enableAnonymousAccess,
                                       String formJson,
                                       MetaCreatorReferenceType referenceType,
                                       String referenceNumber,
                                       String creatorId,
                                       String creatorName,
                                       boolean sync2Identity,
                                       Timestamp beginTime,
                                       Timestamp endTime,
                                       String attachment,
                                       int limitedCount) {
        MetaPageEntity entity = new MetaPageEntity();
        entity.setId(id);
        entity.setProjectId(projectId);
        entity.setModuleId(moduleId);
        entity.setName(name);
        entity.setNote(note);
        entity.setSlug(slug);
        entity.setLogo(logo);
        entity.setPageType(pageType);
        entity.setBusinessType(businessType);
        entity.setTableName(tableName);
        entity.setEnableBPMFlow(enableBPMFlow);
        entity.setEnableAnonymousAccess(enableAnonymousAccess);
        entity.setFormJson(formJson);
        entity.setReferenceType(referenceType);
        entity.setReferenceNumber(referenceNumber);
        entity.setCreatorId(creatorId);
        entity.setCreatorName(creatorName);
        entity.setSync2Identity(sync2Identity);
        entity.setBeginTime(beginTime);
        entity.setEndTime(endTime);
        entity.setAttachment(attachment);
        entity.setLimitedCount(limitedCount);
        entity.setVersion(1L); // 初始版本为1
        entity.setDeleted(false); // 默认未删除

        Timestamp now = new Timestamp(System.currentTimeMillis());
        entity.setCreatedTime(now);
        entity.setLastUpdatedTime(now);
        
        return entity;
    }
}


