package com.bcxin.tenant.bcx.domains.services.commands.projects;

import com.bcxin.tenant.bcx.infrastructures.commands.CommandAbstract;

import java.util.List;

/**
 * 批量逻辑删除项目命令
 */
public class BatchLogicalDeleteProjectCommand extends CommandAbstract {
    private final List<String> ids;

    public BatchLogicalDeleteProjectCommand(List<String> ids) {
        this.ids = ids;
    }

    public List<String> getIds() {
        return ids;
    }

    @Override
    public void validate() {
        if (ids == null || ids.isEmpty()) {
            throw new IllegalArgumentException("项目ID列表不能为空");
        }
    }
}

