package com.bcxin.tenant.bcx.domains.repositories;

import com.bcxin.tenant.bcx.domains.entities.BusOrganRegistryFormsEntity;
import com.bcxin.tenant.bcx.domains.repositories.criterias.OrganRegistryFormsSearchCriteria;
import com.bcxin.tenant.bcx.infrastructures.EntityCollection;
import com.bcxin.tenant.bcx.infrastructures.repositories.RepositoryBase;

import java.sql.Timestamp;
import java.util.List;

/**
 * 企业注册表单仓储接口
 */
public interface OrganRegistryFormsRepository extends RepositoryBase<BusOrganRegistryFormsEntity> {
    /**
     * 搜索企业注册表单
     */
    EntityCollection<BusOrganRegistryFormsEntity> search(OrganRegistryFormsSearchCriteria criteria);

    /**
     * 根据条件查找企业注册表单
     * @param institutionalTypeCode 机构类型编码
     * @param industryTypeCode 行业类型编码
     * @param regionCode 监管区域编码
     * @return 匹配的企业注册表单，如果不存在返回null
     */
    BusOrganRegistryFormsEntity findByCondition(String institutionalTypeCode, String industryTypeCode, String regionCode);

    /**
     * 批量查询企业注册表单
     * @param ids ID列表
     * @return 企业注册表单列表
     */
    List<BusOrganRegistryFormsEntity> getByIds(List<String> ids);

    /**
     * 批量标记为已删除
     * @param ids ID列表
     * @param updateTime 更新时间
     */
    void batchMarkAsDeleted(List<String> ids, Timestamp updateTime);
}
