package com.bcxin.tenant.bcx.domains.repositories;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bcxin.tenant.bcx.infrastructures.EntityCollection;
import com.bcxin.tenant.bcx.infrastructures.entities.Aggregate;
import com.bcxin.tenant.bcx.infrastructures.repositories.RepositoryBase;

import java.io.Serializable;
import java.util.Collection;

public abstract class RepositoryAbstract<T extends Aggregate> implements RepositoryBase<T> {

    protected final BaseMapper<T> mapper;

    protected RepositoryAbstract(BaseMapper<T> mapper) {
        this.mapper = mapper;
    }

    @Override
    public T getById(Object id) {
        return mapper.selectById((Serializable) id);
    }

    @Override
    public void insert(T data) {
        this.mapper.insert(data);
    }

    @Override
    public void update(T data) {
        this.mapper.updateById(data);
    }

    @Override
    public void delete(Object id) {
        this.mapper.deleteById((Serializable) id);
    }

    @Override
    public EntityCollection<T> search(int pageIndex, int pageSize) {
        Page<T> page = new Page<>(pageIndex, pageSize);
        Page<T> result = this.mapper.selectPage(page, null);
        
        return EntityCollection.create(
                result.getRecords(),
                pageSize,
                result.getTotal()
        );
    }

    @Override
    public Collection<T> getAll() {
        return this.mapper.selectList(null);
    }
}
