package com.bcxin.tenant.bcx.domains.repositories;

import com.bcxin.tenant.bcx.domains.entities.MetaPageVersionEntity;
import com.bcxin.tenant.bcx.domains.mappers.MetaPageVersionMapper;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 页面版本仓库实现
 */
@Repository
public class MetaPageVersionRepositoryImpl extends RepositoryAbstract<MetaPageVersionEntity> implements MetaPageVersionRepository {
    private final MetaPageVersionMapper mapper;

    protected MetaPageVersionRepositoryImpl(MetaPageVersionMapper mapper) {
        super(mapper);
        this.mapper = mapper;
    }

    @Override
    public List<MetaPageVersionEntity> getByPageId(String pageId) {
        return mapper.selectByPageId(pageId);
    }

    @Override
    public MetaPageVersionEntity getByPageIdAndVersion(String pageId, long version) {
        return mapper.selectByPageIdAndVersion(pageId, version);
    }
}

