package com.bcxin.tenant.bcx.domains.repositories;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.bcxin.tenant.bcx.domains.entities.MetaPageSettingEntity;
import com.bcxin.tenant.bcx.domains.mappers.MetaPageSettingMapper;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

import java.util.Collection;
import java.util.Collections;

@Repository
public class MetaPageSettingRepositoryImpl
        extends RepositoryAbstract<MetaPageSettingEntity> implements MetaPageSettingRepository {
    protected MetaPageSettingRepositoryImpl(MetaPageSettingMapper mapper) {
        super(mapper);
    }

    @Override
    public Collection<MetaPageSettingEntity> getMatchSettings() {
        LambdaQueryWrapper<MetaPageSettingEntity> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        lambdaQueryWrapper.eq(MetaPageSettingEntity::isEnabled, true);
        /**
         * todo: 根据不同条件进行过滤
         */

        return this.mapper.selectList(lambdaQueryWrapper);
    }

    @Override
    public Collection<MetaPageSettingEntity> findByIds(Collection<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.EMPTY_LIST;
        }

        LambdaQueryWrapper<MetaPageSettingEntity> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        lambdaQueryWrapper.in(MetaPageSettingEntity::getId, ids);

        return this.mapper.selectList(lambdaQueryWrapper);
    }
}
