/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.bcx.domains.repositories;

import com.bcxin.tenant.bcx.domains.components.CacheProvider;
import com.bcxin.tenant.bcx.domains.entities.MetaPageEntity;
import com.bcxin.tenant.bcx.domains.entities.MetaPageTableMappingEntity;
import com.bcxin.tenant.bcx.domains.mappers.MetaPageTableMappingMapper;
import com.bcxin.tenant.bcx.domains.repositories.MetaPageRepository;
import com.bcxin.tenant.bcx.domains.repositories.MetaPageTableMappingRepository;
import com.bcxin.tenant.bcx.domains.repositories.RepositoryAbstract;
import com.bcxin.tenant.bcx.domains.snapshots.DynamicPageTableMappingDataSnapshot;
import com.bcxin.tenant.bcx.infrastructures.components.JsonProvider;
import com.bcxin.tenant.bcx.infrastructures.enums.DataStatus;
import com.bcxin.tenant.bcx.infrastructures.enums.DynamicMappingType;
import com.bcxin.tenant.bcx.infrastructures.enums.PageBusinessType;
import com.bcxin.tenant.bcx.infrastructures.exceptions.NoFoundTenantException;
import com.bcxin.tenant.bcx.infrastructures.exceptions.NotSupportTenantException;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

@Repository
public class MetaPageTableMappingRepositoryImpl
extends RepositoryAbstract<MetaPageTableMappingEntity>
implements MetaPageTableMappingRepository {
    private final CacheProvider cacheProvider;
    private final JsonProvider jsonProvider;
    private final MetaPageRepository metaPageRepository;

    protected MetaPageTableMappingRepositoryImpl(MetaPageTableMappingMapper mapper, CacheProvider cacheProvider, JsonProvider jsonProvider, MetaPageRepository metaPageRepository) {
        super(mapper);
        this.cacheProvider = cacheProvider;
        this.jsonProvider = jsonProvider;
        this.metaPageRepository = metaPageRepository;
    }

    public DynamicPageTableMappingDataSnapshot getSnapshot(String pageId) {
        if (pageId == null) {
            return null;
        }
        MetaPageEntity pageEntity = (MetaPageEntity)this.metaPageRepository.getById((Object)pageId);
        if (pageEntity == null) {
            throw new NoFoundTenantException(String.format("\u9875\u9762\u4e0d\u5b58\u5728(%s)", pageId));
        }
        String mappingId = pageEntity.getTableName();
        if (!StringUtils.hasLength((String)mappingId)) {
            mappingId = pageEntity.getBusinessType() == PageBusinessType.ExamEnrollmentCriteria ? "dynamic_exam_enrollment_00001" : pageId;
        }
        return this.getSnapshotByMappingId(mappingId);
    }

    public DynamicPageTableMappingDataSnapshot getSnapshotByMappingId(String mappingId) {
        DynamicPageTableMappingDataSnapshot snapshot = (DynamicPageTableMappingDataSnapshot)this.cacheProvider.get(MetaPageTableMappingRepositoryImpl.getPageTableMappingCacheKey(mappingId), () -> {
            MetaPageTableMappingEntity entity = (MetaPageTableMappingEntity)this.getById(mappingId);
            if (entity == null) {
                return DynamicPageTableMappingDataSnapshot.empty();
            }
            if (entity.getStatus() != DataStatus.Normal) {
                return null;
            }
            DynamicPageTableMappingDataSnapshot sn = (DynamicPageTableMappingDataSnapshot)this.jsonProvider.toObject(DynamicPageTableMappingDataSnapshot.class, entity.getMappingJson());
            return sn;
        }, DynamicPageTableMappingDataSnapshot.class, 5);
        if (!DynamicPageTableMappingDataSnapshot.isEmpty((DynamicPageTableMappingDataSnapshot)snapshot) && snapshot.getMappingType() != DynamicMappingType.Sql) {
            throw new NotSupportTenantException(String.format("\u4e0d\u652f\u6301\u6b64\u914d\u7f6e(%s)", mappingId));
        }
        return snapshot;
    }

    public void refreshCache(String pageId) {
        this.cacheProvider.delete(MetaPageTableMappingRepositoryImpl.getPageTableMappingCacheKey(pageId));
    }

    private static String getPageTableMappingCacheKey(String pageId) {
        return String.format("paas:bcx:snapshot:pageTableMapping:%s:v2", pageId);
    }
}

