package com.bcxin.tenant.bcx.dubbo.reader.providers.utils;

import org.ansj.domain.Term;
import org.ansj.splitWord.analysis.BaseAnalysis;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.Collection;
import java.util.stream.Collectors;

public class TermUtil {
    public static String getTermKeyword(String input) {
        Collection<Term> terms =
                BaseAnalysis.parse(input).getTerms();

        Collection<String> keyTerms = terms.stream().map(ii -> ii.getName())
                .filter(ii -> StringUtils.hasLength(ii) && ii.trim().length() > 0)
                .collect(Collectors.toList());

        Collection<String> keywordTerms = keyTerms.stream().collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(keywordTerms)) {
            String keyword = keywordTerms.stream().collect(Collectors.joining("**"));
            return "*".concat(keyword).concat("*");
        } else {
            /**
             * 需要加两个*;否则, 无法查询
             */
            String keyword = keyTerms.stream().collect(Collectors.joining("**"));
            return "*".concat(keyword).concat("*");
        }
    }
}
