package com.bcxin.tenant.bcx.jdks.responses.organregistry;

import com.bcxin.tenant.bcx.infrastructures.ResponseAbstract;
import com.bcxin.tenant.bcx.infrastructures.enums.MetaCreatorReferenceType;
import com.bcxin.tenant.bcx.infrastructures.enums.PageBusinessType;
import com.bcxin.tenant.bcx.infrastructures.enums.PageType;
import lombok.Getter;

import java.sql.Timestamp;

/**
 * 企业注册表单响应
 */
@Getter
public class OrganRegistryFormsResponse extends ResponseAbstract {
    private final String id;
    private final String institutionalTypeCode;
    private final String industryTypeCode;
    private final String regionCode;
    private final String pageId;
    private final String pageName; // 关联查询页面名称
    private final String name; // 表单名称
    private final String note; // 备注
    private final String formJson; // 表单结构JSON
    private final String slug; // 页面URL地址
    private final String logo; // Logo图片地址
    private final PageType pageType; // 页面类型
    private final PageBusinessType businessType; // 业务类型
    private final String tableName; // 数据库表名
    private final Boolean enableBPMFlow; // 是否启用流程
    private final Boolean enableAnonymousAccess; // 是否启用匿名访问
    private final String settingJson; // 表单扩展设置JSON
    private final MetaCreatorReferenceType referenceType;
    private final String referenceNumber;
    private final String creatorId;
    private final String lastUpdaterId;
    private final Timestamp lastUpdatedTime;
    private final Timestamp createdTime;
    private final boolean deleted;

    public OrganRegistryFormsResponse(String id, String institutionalTypeCode, String industryTypeCode, 
                                    String regionCode, String pageId, String pageName,
                                    String name, String note, String formJson, String slug, String logo,
                                    PageType pageType, PageBusinessType businessType, String tableName,
                                    Boolean enableBPMFlow, Boolean enableAnonymousAccess, String settingJson,
                                    MetaCreatorReferenceType referenceType, String referenceNumber,
                                    String creatorId, String lastUpdaterId, Timestamp lastUpdatedTime,
                                    Timestamp createdTime, boolean deleted) {
        this.id = id;
        this.institutionalTypeCode = institutionalTypeCode;
        this.industryTypeCode = industryTypeCode;
        this.regionCode = regionCode;
        this.pageId = pageId;
        this.pageName = pageName;
        this.name = name;
        this.note = note;
        this.formJson = formJson;
        this.slug = slug;
        this.logo = logo;
        this.pageType = pageType;
        this.businessType = businessType;
        this.tableName = tableName;
        this.enableBPMFlow = enableBPMFlow;
        this.enableAnonymousAccess = enableAnonymousAccess;
        this.settingJson = settingJson;
        this.referenceType = referenceType;
        this.referenceNumber = referenceNumber;
        this.creatorId = creatorId;
        this.lastUpdaterId = lastUpdaterId;
        this.lastUpdatedTime = lastUpdatedTime;
        this.createdTime = createdTime;
        this.deleted = deleted;
    }

    public static OrganRegistryFormsResponse from(String id, String institutionalTypeCode, String industryTypeCode, 
                                                String regionCode, String pageId, String pageName,
                                                String name, String note, String formJson, String slug, String logo,
                                                PageType pageType, PageBusinessType businessType, String tableName,
                                                Boolean enableBPMFlow, Boolean enableAnonymousAccess, String settingJson,
                                                MetaCreatorReferenceType referenceType, String referenceNumber,
                                                String creatorId, String lastUpdaterId, Timestamp lastUpdatedTime,
                                                Timestamp createdTime, boolean deleted) {
        return new OrganRegistryFormsResponse(id, institutionalTypeCode, industryTypeCode, regionCode, pageId, pageName,
                name, note, formJson, slug, logo, pageType, businessType, tableName, enableBPMFlow, enableAnonymousAccess, settingJson,
                referenceType, referenceNumber, creatorId, lastUpdaterId, lastUpdatedTime, createdTime, deleted);
    }
}
