package com.bcxin.tenant.bcx.jdks.responses.metas;

import com.bcxin.tenant.bcx.infrastructures.ResponseAbstract;
import com.bcxin.tenant.bcx.infrastructures.snapshots.metas.*;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;

@Schema(name = "PageSettingResponse", title = "页面设置配置")
@Getter
public class PageSettingResponse extends ResponseAbstract {
    @Schema(name = "variables", title = "可用的表单变量",
            description = "分为三部分: 1、系统级变量; 2、会话级变量; 3、租户级变量")
    private final Map<String, MetaPageVariableSnapshot> variables;

    @Schema(name = "fields", title = "可用的系统字段(区分页面)",
            description = "分为三部分: 1、基础控件(行业/机构信息); 2、租户控件(用户/部门控件); 3、管理控件(主管/监管控件)")
    private final Collection<MetaPageFieldGroupResponse> fields;

    @Schema(name = "classes", title = "类信息", description = "系统类")
    private final Map<String, MetaPageGlobalClassSnapshot> classes;

    @Schema(name = "events", title = "事件集", description = "表单的全局事件内容")
    private final Map<String, MetaPageGlobalEventSnapshot> events;

    @Schema(name = "settings", title = "设置信息", description = "表单的设置信息")
    private final Map<String, MetaPageGlobalSettingDataSnapshot> settings;

    public PageSettingResponse(Map<String, MetaPageVariableSnapshot> variables,
                               Collection<MetaPageFieldGroupResponse> fields,
                               Map<String, MetaPageGlobalClassSnapshot> classes,
                               Map<String, MetaPageGlobalEventSnapshot> events,
                               Map<String, MetaPageGlobalSettingDataSnapshot> settings) {
        this.variables = variables;
        this.fields = fields;
        this.classes = classes;
        this.events = events;
        this.settings = settings;
    }

    public static PageSettingResponse create(Map<String, MetaPageVariableSnapshot> variables,
                                             Collection<MetaPageFieldGroupResponse> fields,
                                             Map<String, MetaPageGlobalClassSnapshot> classes,
                                             Map<String, MetaPageGlobalEventSnapshot> events,
                                             Map<String, MetaPageGlobalSettingDataSnapshot> settings) {
        return new PageSettingResponse(variables, fields, classes, events, settings);
    }

    @Getter
    public static class MetaPageFieldGroupResponse extends ResponseAbstract {
        private final String label;
        private final Collection<MetaPageFieldSnapshot> children;

        public MetaPageFieldGroupResponse(String label) {
            this.label = label;
            this.children = new HashSet<>();
        }

        public void addChild(Collection<MetaPageFieldSnapshot> children) {
            this.children.addAll(children);
        }

        public static MetaPageFieldGroupResponse create(String label) {
            return new MetaPageFieldGroupResponse(label);
        }
    }
}
