package com.bcxin.tenant.bcx.jdks;

import com.bcxin.tenant.bcx.infrastructures.EntityCollection;
import com.bcxin.tenant.bcx.jdks.requests.metas.MenuMetaRequest;
import com.bcxin.tenant.bcx.jdks.requests.metas.MenuMetaSearchRequest;
import com.bcxin.tenant.bcx.jdks.responses.metas.MenuMetaResponse;

/**
 * 菜单元数据RPC提供者接口
 */
public interface MenuMetaRpcProvider {
    /**
     * 创建菜单
     */
    void create(MenuMetaRequest request);

    /**
     * 更新菜单
     */
    void update(String id, MenuMetaRequest request);

    /**
     * 删除菜单
     */
    void delete(String id);

    /**
     * 搜索菜单
     */
    EntityCollection<MenuMetaResponse> search(MenuMetaSearchRequest request);

    /**
     * 根据ID获取菜单
     */
    MenuMetaResponse getById(String id);
}
