package com.bcxin.tenant.bcx.jdks;

import com.bcxin.tenant.bcx.infrastructures.EntityCollection;
import com.bcxin.tenant.bcx.jdks.requests.pages.BatchPageDataRequest;
import com.bcxin.tenant.bcx.jdks.requests.pages.MappingPageDataSearchRequest;
import com.bcxin.tenant.bcx.jdks.requests.pages.PageDataRequest;
import com.bcxin.tenant.bcx.jdks.requests.pages.PageDataSearchRequest;
import com.bcxin.tenant.bcx.jdks.responses.pages.PageDataResponse;

public interface PageDataRpcProvider {
    String create(PageDataRequest request);

    void update(String id, PageDataRequest request);

    void delete(String pageId, String id);

    PageDataResponse getById(String pageId, String id);

    EntityCollection<PageDataResponse> search(PageDataSearchRequest request);

    EntityCollection<PageDataResponse> search(MappingPageDataSearchRequest request);

    void batchCreate(BatchPageDataRequest request);
}
