package com.bcxin.tenant.bcx.infrastructures.flinks;

import com.bcxin.tenant.bcx.infrastructures.components.JsonProvider;
import lombok.AccessLevel;
import lombok.Getter;

@Getter
public class JobParameterDTO {
    private final String name;
    private final String parameterJson;
    private final String description;

    @Getter(AccessLevel.PRIVATE)
    private JobExecutorParam param;

    public JobParameterDTO(String name,  String parameterJson, String description) {
        this.name = name;
        this.parameterJson = parameterJson;
        this.description = description;
    }

    public static JobParameterDTO create(String name, String parameterJson, String description) {
        return new JobParameterDTO(name, parameterJson, description);
    }

    public String getParam1(JsonProvider jsonProvider) {
        JobExecutorParam p = this.getJobExecutorParam(jsonProvider);

        if (p == null) {
            return null;
        }

        return p.getParam1();
    }

    public String getParam2(JsonProvider jsonProvider) {
        JobExecutorParam p = this.getJobExecutorParam(jsonProvider);

        if (p == null) {
            return null;
        }

        return p.getParam2();
    }

    private JobExecutorParam getJobExecutorParam(JsonProvider jsonProvider) {
        if (this.getParam() == null) {
            this.param = jsonProvider.toObject(JobExecutorParam.class, this.getParameterJson());
        }

        return this.param;
    }
}
