package com.bcxin.tenant.bcx.infrastructures.valueTypes;

import lombok.Data;

@Data
public class LocationAddressValueType extends ValueTypeAbstract{
    private String country;
    private String province;
    private String city;
    private String district;
    private String street;
    private String streetNum;
    private String poiName;
    private String cityCode;

    public LocationAddressValueType(){}

    public static LocationAddressValueType create(String country,
                                                  String province,
                                                  String city,
                                                  String district,
                                                  String street,
                                                  String streetNum,
                                                  String poiName,
                                                  String cityCode) {
        LocationAddressValueType addressValueType = new LocationAddressValueType();
        addressValueType.setCountry(country);
        addressValueType.setProvince(province);
        addressValueType.setCountry(city);
        addressValueType.setDistrict(district);
        addressValueType.setStreet(street);
        addressValueType.setStreetNum(streetNum);
        addressValueType.setPoiName(poiName);
        addressValueType.setCityCode(cityCode);

        return addressValueType;
    }
}
