package com.bcxin.tenant.bcx.infrastructures.utils;

import com.bcxin.tenant.bcx.infrastructures.components.JsonProvider;
import com.bcxin.tenant.bcx.infrastructures.exceptions.BadTenantException;

import java.util.Map;
import java.util.Properties;

public class PropertyUtils {
    public static Properties loadProperties(JsonProvider jsonProvider, String param1) {
        if (StringUtil.isEmpty(param1)) {
            throw new BadTenantException("流任务配置信息不能为空");
        }

        String taskConf = param1;
        Map<String, String> inputMap = jsonProvider.toObject(Map.class, taskConf);

        Properties properties = System.getProperties();
        for (String key : inputMap.keySet()) {
            properties.setProperty(key, inputMap.get(key));
        }

        return properties;
    }
}
