package com.bcxin.tenant.bcx.infrastructures;

import lombok.Data;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@Data
public class EntityCollection<T> implements Serializable {
    private Collection<T> data;
    private Long totalCount;
    private int pageSize;
    private Map<String,Object> exMap;

    public EntityCollection() {
        this.exMap = new HashMap<>();
    }

    public static <T> EntityCollection<T> create(Collection<T> data, int pageSize, Long totalCount) {
        EntityCollection ec = new EntityCollection();
        ec.setData(data);
        ec.setTotalCount(totalCount);
        ec.setPageSize(pageSize);

        return ec;
    }

    public static <T> EntityCollection<T> createForNoTotalCount(Collection<T> data,int pageSize) {
        EntityCollection ec = new EntityCollection();
        ec.setData(data);
        ec.setPageSize(pageSize);

        return ec;
    }

    public int getPageCount() {
        if(this.getPageSize()==0) {
            return 0;
        }

        int pageCount = (int) Math.ceil(this.getTotalCount() * 1.0 / this.getPageSize());

        return pageCount;
    }

    public static EntityCollection EMPTY() {
        return EntityCollection.create(Collections.EMPTY_LIST, 0, 0l);
    }

    public boolean endOfData() {
        return this.getData().size() < this.getPageSize();
    }

    public void addExMap(String key,Object value) {
        this.exMap.put(key,value);
    }
}
