/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.bcx.infrastructures.enums;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;

public enum MenuMediumType {
    PC(1, "\u9002\u7528\u4e8ePC\u7aef"),
    APP(2, "\u9002\u7528\u4e8eAPP\u7aef");

    private final int value;
    private final String name;

    private MenuMediumType(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public String getTypeName() {
        return this.name;
    }

    public int getTypeValue() {
        return this.value;
    }

    public static Set<MenuMediumType> toMenuMediumTypes(Set<String> mediumTypeNames) {
        if (mediumTypeNames == null || mediumTypeNames.isEmpty()) {
            return Collections.emptySet();
        }
        return mediumTypeNames.stream().filter(name -> name != null && !name.isEmpty()).map(name -> {
            try {
                return MenuMediumType.valueOf(name);
            }
            catch (IllegalArgumentException ex) {
                return null;
            }
        }).filter(mm -> mm != null).collect(Collectors.toSet());
    }

    public static boolean hasMenuMediumType(Set<String> mediumTypeNames, MenuMediumType target) {
        if (target == null) {
            return false;
        }
        Set<MenuMediumType> set = MenuMediumType.toMenuMediumTypes(mediumTypeNames);
        return set.contains((Object)target);
    }

    public static int getCalculatedMediumValue(Set<MenuMediumType> mediums) {
        int calculatedValue = 0;
        if (mediums == null || mediums.isEmpty()) {
            return calculatedValue;
        }
        for (MenuMediumType m : mediums) {
            calculatedValue |= m.getTypeValue();
        }
        return calculatedValue;
    }

    public static int getCalculatedMediumValueByNames(Collection<String> mediumTypeNames) {
        if (mediumTypeNames == null || mediumTypeNames.isEmpty()) {
            return 0;
        }
        Set<MenuMediumType> mediums = mediumTypeNames.stream().filter(name -> name != null && !name.isEmpty()).map(name -> {
            try {
                return MenuMediumType.valueOf(name);
            }
            catch (IllegalArgumentException ex) {
                return null;
            }
        }).filter(mm -> mm != null).collect(Collectors.toSet());
        return MenuMediumType.getCalculatedMediumValue(mediums);
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }
}

