package com.bcxin.tenant.bcx.domains.services.commands.organregistry;

import com.bcxin.tenant.bcx.infrastructures.commands.CommandAbstract;
import com.bcxin.tenant.bcx.infrastructures.enums.MetaCreatorReferenceType;
import com.bcxin.tenant.bcx.infrastructures.enums.PageBusinessType;
import com.bcxin.tenant.bcx.infrastructures.enums.PageType;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 更新企业注册表单命令
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class UpdateOrganRegistryFormsCommand extends CommandAbstract {
    
    /**
     * 主键ID
     */
    private String id;

    /**
     * 机构类型编码，关联sys_institutional_types.code
     */
    private String institutionalTypeCode;

    /**
     * 行业类型编码，关联sys_industry_types.code
     */
    private String industryTypeCode;

    /**
     * 监管区域编码
     */
    private String regionCode;

    /**
     * 页面ID，关联meta_pages.id
     */
    private String pageId;

    /**
     * 表单名称
     */
    private String name;

    /**
     * 备注
     */
    private String note;

    /**
     * 表单结构JSON
     */
    private String formJson;

    /**
     * 页面URL地址
     */
    private String slug;

    /**
     * Logo图片地址
     */
    private String logo;

    /**
     * 页面类型
     */
    private PageType pageType;

    /**
     * 业务类型
     */
    private PageBusinessType businessType;

    /**
     * 数据库表名
     */
    private String tableName;

    /**
     * 是否启用流程
     */
    private Boolean enableBPMFlow;

    /**
     * 是否启用匿名访问
     */
    private Boolean enableAnonymousAccess;

    /**
     * 表单扩展设置JSON
     */
    private String settingJson;

    // 添加静态工厂方法
    public static UpdateOrganRegistryFormsCommand create(String id, String institutionalTypeCode, String industryTypeCode,
                                                       String regionCode, String pageId, String name, String note,
                                                       String formJson, String slug, String logo, PageType pageType,
                                                       PageBusinessType businessType, String tableName, Boolean enableBPMFlow, Boolean enableAnonymousAccess,
                                                       String settingJson) {
        UpdateOrganRegistryFormsCommand command = new UpdateOrganRegistryFormsCommand();
        command.setId(id);
        command.setInstitutionalTypeCode(institutionalTypeCode);
        command.setIndustryTypeCode(industryTypeCode);
        command.setRegionCode(regionCode);
        command.setPageId(pageId);
        command.setName(name);
        command.setNote(note);
        command.setFormJson(formJson);
        command.setSlug(slug);
        command.setLogo(logo);
        command.setPageType(pageType);
        command.setBusinessType(businessType);
        command.setTableName(tableName);
        command.setEnableBPMFlow(enableBPMFlow);
        command.setEnableAnonymousAccess(enableAnonymousAccess);
        command.setSettingJson(settingJson);
        return command;
    }

    @Override
    public void validate() {
        if (id == null || id.trim().isEmpty()) {
            throw new IllegalArgumentException("ID不能为空");
        }
        // 其他字段可以为null，表示不更新该字段
        // 如果name不为null，则需要验证
        if (name != null && name.trim().isEmpty()) {
            throw new IllegalArgumentException("表单名称不能为空字符串");
        }
    }
}