package com.bcxin.tenant.bcx.domains.services;

import com.bcxin.tenant.bcx.domains.entities.MetaProjectEntity;
import com.bcxin.tenant.bcx.domains.services.commands.DeleteDataCommand;
import com.bcxin.tenant.bcx.domains.services.commands.projects.BatchLogicalDeleteProjectCommand;
import com.bcxin.tenant.bcx.domains.services.commands.projects.CreateMetaProjectCommand;
import com.bcxin.tenant.bcx.domains.services.commands.projects.LogicalDeleteProjectCommand;
import com.bcxin.tenant.bcx.domains.services.commands.projects.UpdateMetaProjectCommand;
import com.bcxin.tenant.bcx.infrastructures.EntityCollection;

public interface MetaProjectService {
    void dispatch(CreateMetaProjectCommand command);

    void dispatch(UpdateMetaProjectCommand command);

    void dispatch(DeleteDataCommand command);

    /**
     * 逻辑删除项目
     */
    void dispatch(LogicalDeleteProjectCommand command);

    /**
     * 批量逻辑删除项目
     */
    void dispatch(BatchLogicalDeleteProjectCommand command);

    EntityCollection<MetaProjectEntity> search(int pageIndex, int pageSize);

    MetaProjectEntity getById(String id);
}
