package com.bcxin.tenant.bcx.domains.entities.valueTypes;

import java.io.Serializable;

public class GeoPointValueType implements Serializable {
    /**
     * 纬度
     */
    private double lat;
    /**
     * 经度
     */
    private double lon;

    public GeoPointValueType() {
    }

    /**
     * 创建经维度坐标
     *
     * @param lat 纬度
     * @param lon 经度
     */
    public GeoPointValueType(double lat, double lon) {
        this.lat = lat;
        this.lon = lon;
    }

    public double getLat() {
        return lat;
    }

    public void setLat(double lat) {
        this.lat = lat;
    }

    public double getLon() {
        return lon;
    }

    public void setLon(double lon) {
        this.lon = lon;
    }

    @Override
    public String toString() {
        return "GeoPoint{" +
                "lat=" + lat +
                ", lon=" + lon +
                '}';
    }

    public static GeoPointValueType create(double lat, double lng) {
        return new GeoPointValueType(lat, lng);
    }
}
