package com.bcxin.tenant.bcx.domains.entities;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.tenant.bcx.domains.constants.DynamicConstants;
import com.bcxin.tenant.bcx.domains.snapshots.DynamicPageDataJsonSnapshot;
import com.bcxin.tenant.bcx.domains.snapshots.DynamicPageValueSnapshot;
import com.bcxin.tenant.bcx.infrastructures.TenantEmployeeContext;
import com.bcxin.tenant.bcx.infrastructures.components.JsonProvider;
import com.bcxin.tenant.bcx.infrastructures.constants.BusinessConstants;
import com.bcxin.tenant.bcx.infrastructures.entities.Aggregate;
import com.bcxin.tenant.bcx.infrastructures.entities.EntityAbstract;
import com.bcxin.tenant.bcx.infrastructures.enums.PageBusinessType;
import com.bcxin.tenant.bcx.domains.snapshots.DynamicPageTableMappingDataSnapshot;
import com.bcxin.tenant.bcx.infrastructures.exceptions.ArgumentTenantException;
import com.bcxin.tenant.bcx.infrastructures.exceptions.BadTenantException;
import lombok.Data;
import org.apache.ibatis.type.EnumOrdinalTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

import java.sql.Timestamp;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;

@Data
@TableName(value = "dynamic_page_data",autoResultMap = true)
public class DynamicPageDataEntity extends EntityAbstract implements Aggregate {
    private static final Logger logger = LoggerFactory.getLogger(DynamicPageDataEntity.class);

    @TableId
    private String id;

    @TableField(value = "page_id")
    private String pageId;

    @TableField(value = "version")
    private long version;

    @TableField(value = "created_time")
    private Timestamp createdTime;

    @TableField(value = "last_updated_time")
    private Timestamp lastUpdatedTime;

    @TableField(value = "creator_id")
    private String creatorId;

    /**
     * 最后修改人Id
     */
    @TableField(value = "last_updater_id")
    private String lastUpdaterId;

    @TableField(value = "domain_id")
    private String domainId;

    @TableField(value = "data_json")
    private String dataJson;

    @TableField(value = "business_type", jdbcType = JdbcType.TINYINT, javaType = true, typeHandler = EnumOrdinalTypeHandler.class)
    private PageBusinessType businessType;

    /**
     * 纯粹为了性能, 在下一步的时候省的反序列化
     */
    @TableField(exist = false)
    private DynamicPageDataJsonSnapshot jsonSnapshot;

    public DynamicPageDataEntity() {
        this.setCreatedTime(Timestamp.from(Instant.now()));
        this.setCreatorId(BusinessConstants.DefaultEmptyValue);
        this.setDomainId(BusinessConstants.DefaultEmptyValue);
    }

    public DynamicPageDataEntity(String id, String domainId, String creatorId, MetaPageEntity page) {
        this();
        this.setId(id);
        this.setPageId(page.getId());

        this.setCreatorId(creatorId);
        this.setDomainId(domainId);
        this.setVersion(page.getVersion());
        this.setBusinessType(page.getBusinessType());
    }

    public void change(DynamicPageDataJsonSnapshot snapshot, JsonProvider jsonProvider, TenantEmployeeContext.TenantUserModel userModel) {
        this.setJsonSnapshot(snapshot);
        this.setDataJson(jsonProvider.getJson(snapshot));
        this.setLastUpdatedTime(Timestamp.from(Instant.now()));

        /**
         * 提交的数据有些也是允许为空的
         */
        String userId = null;
        if (userModel != null) {
            userId = userModel.getId();
        }
        this.setLastUpdaterId(userId);
    }

    public static DynamicPageDataEntity create(String id, TenantEmployeeContext.TenantUserModel userModel, MetaPageEntity page) {
        String organizationId = null;
        String userId = null;
        if (userModel != null) {
            organizationId = userModel.getOrganizationId();
            userId = userModel.getId();
        }

        return new DynamicPageDataEntity(id, organizationId, userId, page);
    }

    public static DynamicPageDataEntity createForMappingData(String id,
                                                             String pageId,
                                                             long version,
                                                             PageBusinessType businessType,
                                                             DynamicPageDataJsonSnapshot snapshot,
                                                             String domainId,
                                                             String lastUpdaterId,
                                                             String creatorId,
                                                             Timestamp createdTime,
                                                             Timestamp lastUpdatedTime,
                                                             JsonProvider jsonProvider) {
        DynamicPageDataEntity entity = new DynamicPageDataEntity();
        entity.setId(id);
        entity.setVersion(version);
        entity.setPageId(pageId);
        entity.setCreatorId(creatorId);
        entity.setDomainId(domainId);
        entity.setBusinessType(businessType);
        entity.setCreatedTime(createdTime);
        entity.setLastUpdaterId(lastUpdaterId);
        entity.setLastUpdatedTime(lastUpdatedTime);
        entity.setJsonSnapshot(snapshot);
        entity.setDataJson(jsonProvider.getJson(snapshot));

        return entity;
    }
}
