package com.bcxin.tenant.bcx.domains.dtos;

import com.bcxin.tenant.bcx.infrastructures.enums.ExamReferenceType;
import com.bcxin.tenant.bcx.infrastructures.enums.PageType;
import lombok.Data;

import java.sql.Date;
import java.sql.Timestamp;

@Data
public class ExamEnrollmentCriteriaDTO extends AbstractDTO {
    private String id;
    private ExamReferenceType subjectType;
    private String subjectName;
    private String subjectNumber;
    private String name;
    private boolean sync2Saas;
    private String note;

    private Timestamp beginTime;
    private Timestamp endTime;
    private String attachment;
    private int limitedCount;
    private String slug;
    private String logo;
    private String projectId;
    private String moduleId;
    private boolean enableBPMFlow;
    private boolean enableAnonymousAccess;
    private Timestamp createdTime;
    private String creatorName;

    public static ExamEnrollmentCriteriaDTO create(String id,ExamReferenceType subjectType,
                                                   String subjectName,
                                                   String subjectNumber,
                                                   String name,
                                                   boolean sync2Saas,
                                                   String note,
                                                   Timestamp beginTime,
                                                   Timestamp endTime,
                                                   String attachment,
                                                   int limitedCount,
                                                   String slug,
                                                   String logo,
                                                   String projectId,
                                                   String moduleId,
                                                   boolean enableBPMFlow,
                                                   boolean enableAnonymousAccess,
                                                   Timestamp createdTime,
                                                   String creatorName
                                                   ) {
        ExamEnrollmentCriteriaDTO dto = new ExamEnrollmentCriteriaDTO();
        dto.setId(id);
        dto.setSubjectName(subjectName);
        dto.setAttachment(attachment);
        dto.setBeginTime(beginTime);
        dto.setEndTime(endTime);
        dto.setEnableAnonymousAccess(enableAnonymousAccess);
        dto.setEnableBPMFlow(enableBPMFlow);
        dto.setLogo(logo);
        dto.setLimitedCount(limitedCount);
        dto.setModuleId(moduleId);
        dto.setName(name);
        dto.setNote(note);
        dto.setProjectId(projectId);
        dto.setSlug(slug);
        dto.setSync2Saas(sync2Saas);
        dto.setSubjectNumber(subjectNumber);
        dto.setSubjectType(subjectType);
        dto.setCreatedTime(createdTime);
        dto.setCreatorName(creatorName);

        return dto;
    }
}
