package com.bcxin.tenant.bcx.domains.criterias;

import com.bcxin.tenant.bcx.infrastructures.criterias.CriteriaAbstract;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

@Getter
public class DynamicQueryCriteria extends CriteriaAbstract {
    private final String dsl;
    private final Map<String, Object> params;

    private final Map<String, Object> advanceParams;

    public DynamicQueryCriteria(String dsl) {
        this.dsl = dsl;
        this.params = new HashMap<>();
        this.advanceParams = new HashMap<>();
    }

    public void addParam(String key, Object value) {
        this.params.put(key, value);
    }

    public void addAdvanceParam(String key, Object value) {
        this.advanceParams.put(key, value);
    }

    public static DynamicQueryCriteria create(String dsl)
    {
        return new DynamicQueryCriteria(dsl);
    }
}
