package com.bcxin.tenant.bcx.domains.wrappers;

import com.bcxin.tenant.bcx.domains.constants.DynamicConstants;
import com.bcxin.tenant.bcx.domains.entities.DynamicPageDataEntity;
import com.bcxin.tenant.bcx.domains.snapshots.DynamicPageTableMappingDataSnapshot;
import com.bcxin.tenant.bcx.infrastructures.components.JsonProvider;
import com.bcxin.tenant.bcx.infrastructures.enums.DynamicMappingType;
import com.bcxin.tenant.bcx.infrastructures.exceptions.ArgumentTenantException;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;

@Getter
@Setter(AccessLevel.PROTECTED)
public class DynamicDataWrapper implements Serializable {
    private DynamicMappingType mappingType;
    private DynamicPageTableMappingDataSnapshot.DslDataMappingSnapshot dsl;
    private Map<String, Object> params = new HashMap<>();
    private int pageIndex=1;
    private int pageSize=10;
    private boolean ignorePage = false;

    public DynamicDataWrapper() {
        this.getParams().put(DynamicConstants.DYNAMIC_SYS_DOMAIN_ID, DynamicConstants.DEFAULT_EMPTY_VALUE);
        this.getParams().put(DynamicConstants.DYNAMIC_SYS_CREATOR_ID, DynamicConstants.DEFAULT_EMPTY_VALUE);
        this.getParams().put(DynamicConstants.DYNAMIC_SYS_LAST_UPDATER_ID, DynamicConstants.DEFAULT_EMPTY_VALUE);

        Timestamp now = Timestamp.from(Instant.now());
        this.getParams().put(DynamicConstants.DYNAMIC_SYS_CREATED_TIME, now);
        this.getParams().put(DynamicConstants.DYNAMIC_SYS_CREATED_TIME, now);
    }

    public static DynamicDataWrapper create(DynamicPageTableMappingDataSnapshot tableMapping,
                                            DynamicPageDataEntity entity,
                                            JsonProvider jsonProvider
    ) {
        if (entity == null) {
            throw new ArgumentTenantException("系统参数异常");
        }

        DynamicDataWrapper wrapper = new DynamicDataWrapper();
        wrapper.setDsl(tableMapping.getDsl());
        wrapper.setMappingType(tableMapping.getMappingType());
        tableMapping.buildAndFillWrapper(wrapper,entity,jsonProvider);

        return wrapper;
    }

    public static DynamicDataWrapper createForGetAndDeleteAction(
            DynamicPageTableMappingDataSnapshot tableMapping,
                                                           String pageId, String id) {
        DynamicDataWrapper wrapper = new DynamicDataWrapper();
        wrapper.setDsl(tableMapping.getDsl());
        wrapper.setMappingType(tableMapping.getMappingType());
        wrapper.getParams().put("pageId", pageId);
        wrapper.getParams().put("id", id);

        return wrapper;
    }

    public static DynamicDataWrapper createForSearch(
            DynamicPageTableMappingDataSnapshot tableMapping,
            Map<String,Object> params,
            boolean ignorePage,
            int pageIndex,
            int pageSize) {
        DynamicDataWrapper wrapper = new DynamicDataWrapper();
        wrapper.setDsl(tableMapping.getDsl());
        wrapper.setIgnorePage(ignorePage);
        wrapper.setPageIndex(pageIndex);
        wrapper.setPageSize(pageSize);

        wrapper.setMappingType(tableMapping.getMappingType());
        if (params != null) {
            wrapper.setParams(params);
        }

        return wrapper;
    }

    public void addParam(String key, Object value) {
        this.params.put(key, value);
    }

    public void addParams(Map<String, Object> params) {
        this.params.putAll(params);
    }
}
