package com.bcxin.tenant.bcx.domains.snapshots;

import com.bcxin.tenant.bcx.domains.constants.DynamicConstants;
import com.bcxin.tenant.bcx.domains.entities.DynamicPageDataEntity;
import com.bcxin.tenant.bcx.domains.wrappers.DynamicDataWrapper;
import com.bcxin.tenant.bcx.infrastructures.components.JsonProvider;
import com.bcxin.tenant.bcx.infrastructures.enums.DynamicMappingType;
import com.bcxin.tenant.bcx.infrastructures.exceptions.BadTenantException;
import com.bcxin.tenant.bcx.infrastructures.snapshots.SnapshotAbstract;
import lombok.Data;
import org.springframework.util.CollectionUtils;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

@Data
public class DynamicPageTableMappingDataSnapshot extends SnapshotAbstract {

    private String name;
    private String tableName;
    private DynamicMappingType mappingType;
    private DslDataMappingSnapshot dsl;
    private Map<String,String> columnMaps;

    @Data
    public static class DslDataMappingSnapshot extends SnapshotAbstract {
        private String insertDsl;
        private String updateDsl;
        private String deleteDsl;
        private String queryDsl;
        private String queryDslById;
    }

    private static DynamicPageTableMappingDataSnapshot _empty = new DynamicPageTableMappingDataSnapshot();
    public static DynamicPageTableMappingDataSnapshot empty() {
        return _empty;
    }

    public static boolean isEmpty(DynamicPageTableMappingDataSnapshot snapshot) {
        return snapshot == null || snapshot == _empty || snapshot.getDsl()==null;
    }

    public void buildAndFillWrapper(DynamicDataWrapper wrapper, DynamicPageDataEntity entity, JsonProvider jsonProvider) {
        DynamicPageDataJsonSnapshot snapshot = entity.getJsonSnapshot();
        /**
         * 对应特定的列, 我们不采用序列化的方式进行
         */
        Map<String, Object> oItems = new HashMap<>();
        Map<String, String> columnMappings = new HashMap<>();
        if (CollectionUtils.isEmpty(this.getColumnMaps())) {
            wrapper.addParams(snapshot.getItems());
            for (Map.Entry<String, Object> entry : snapshot.getItems().entrySet()) {
                wrapper.addParam(entry.getKey(), entry.getValue());
                oItems.put(entry.getKey(), entry.getValue());
            }
        } else {
            Collection<String> allParamKeys = snapshot.getItems().keySet();
            for (String pKey : allParamKeys) {
                String matchedKey = this.getColumnMaps().get(pKey);
                if (matchedKey == null) {
                    wrapper.getParams().put(pKey, snapshot.getItems().get(pKey));
                    /**
                     * 没在columns的参数全部都放入oItems中
                     */
                    oItems.put(pKey, snapshot.getItems().get(pKey));
                } else {
                    wrapper.getParams().put(pKey, snapshot.getItems().get(pKey));
                    wrapper.getParams().put(matchedKey, snapshot.getItems().get(pKey));
                    columnMappings.put(matchedKey, pKey);
                }
            }
        }

        if (wrapper.getParams().containsKey(DynamicConstants.DYNAMIC_SYS_JSON_FIELD)) {
            throw new BadTenantException(String.format("系统参数字段异常: %s是系统保留字段, 请联系管理员", DynamicConstants.DYNAMIC_SYS_JSON_FIELD));
        }

        /**
         * 附加组件
         */
        DynamicPageValueSnapshot valueSnapshot = DynamicPageValueSnapshot.create(
                entity.getPageId(),
                entity.getVersion(),
                entity.getBusinessType(),
                oItems,
                columnMappings
        );

        wrapper.getParams().put(DynamicConstants.DYNAMIC_SYS_JSON_FIELD, jsonProvider.getJson(valueSnapshot));

        wrapper.getParams().put(DynamicConstants.DYNAMIC_SYS_PAGE_ID, entity.getPageId());
        wrapper.getParams().put(DynamicConstants.DYNAMIC_SYS_ID, entity.getId());
    }
}
