package com.bcxin.tenant.bcx.domains.services.commands.pages;

import com.bcxin.tenant.bcx.infrastructures.commands.CommandAbstract;
import lombok.Getter;

/**
 * 保存页面表单JSON命令
 * 专用于只更新formJson和settingJson的场景
 */
@Getter
public class SavePageFormJsonCommand extends CommandAbstract {
    private final String id;
    private final String formJson;
    private final String formSettingJson;
    private String lastUpdaterId; // 由AOP切面自动填充

    public SavePageFormJsonCommand(String id, String formJson, String formSettingJson) {
        this.id = id;
        this.formJson = formJson;
        this.formSettingJson = formSettingJson;
    }

    public void setLastUpdaterId(String lastUpdaterId) {
        this.lastUpdaterId = lastUpdaterId;
    }
}

