package com.bcxin.tenant.bcx.domains.services.commands.pageSettings;

import com.bcxin.tenant.bcx.infrastructures.commands.CommandAbstract;
import com.bcxin.tenant.bcx.infrastructures.enums.MetaPageSettingType;
import lombok.Getter;

@Getter
public class CreatePageSettingCommand extends CommandAbstract {
    private final String name;

    private final String note;

    private final String identity;
    private final String jsonConfig;
    private final MetaPageSettingType settingType;
    private final String condition;
    private final boolean enabled;

    public CreatePageSettingCommand(
            String name,
            String identity, String jsonConfig,
            String note,
            MetaPageSettingType settingType, String condition,
            boolean enabled) {
        this.name = name;
        this.note = note;
        this.identity = identity;
        this.jsonConfig = jsonConfig;
        this.settingType = settingType;
        this.condition = condition;
        this.enabled = enabled;
    }

    public static CreatePageSettingCommand create(
            String name,
            String identity, String jsonConfig,
            String note,
            MetaPageSettingType settingType, String condition,
            boolean enabled
    ) {
        return new CreatePageSettingCommand(
                name,
                identity, jsonConfig,
                note,
                settingType, condition, enabled);
    }
}
