package com.bcxin.tenant.bcx.domains.services.commands;

import com.bcxin.tenant.bcx.domains.entities.AnalyticsLogEntity;
import com.bcxin.tenant.bcx.infrastructures.commands.CommandAbstract;
import lombok.Getter;

import java.util.Collection;

@Getter
public class CreateAnalyticsLogCommand extends CommandAbstract {
    private final Collection<AnalyticsLogEntity> analyticsLogs;

    public CreateAnalyticsLogCommand(Collection<AnalyticsLogEntity> analyticsLogs) {
        this.analyticsLogs = analyticsLogs;
    }

    public static CreateAnalyticsLogCommand create(Collection<AnalyticsLogEntity> analyticsLogs){
        return new CreateAnalyticsLogCommand(analyticsLogs);
    }
}
