package com.bcxin.tenant.bcx.domains.entities;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.tenant.bcx.infrastructures.entities.Aggregate;
import com.bcxin.tenant.bcx.infrastructures.entities.EntityAbstract;
import com.bcxin.tenant.bcx.infrastructures.enums.MetaPageSettingType;
import lombok.Data;
import org.apache.ibatis.type.EnumOrdinalTypeHandler;
import org.apache.ibatis.type.JdbcType;

import java.sql.Timestamp;
import java.time.Instant;

@Data
@TableName(value = "meta_page_settings",autoResultMap = true)
public class MetaPageSettingEntity extends EntityAbstract implements Aggregate {
    @TableId(value = "id")
    private String id;

    @TableField(value = "name")
    private String name;

    /**
     * 对应于:
     * data_static_data_type: {
     *         label: "自定义数据",
     *         type: "static",
     *         data: [1, 2, 3, 4],
     *         deletable: false,
     *       }
     * 的
     * data_static_data_type 值
     */
    @TableField(value = "identity")
    private String identity;

    /**
     * 对应于:
     * data_static_data_type: {
     *         label: "自定义数据",
     *         type: "static",
     *         data: [1, 2, 3, 4],
     *         deletable: false,
     *       }
     * 的
     * {
     *         label: "自定义数据",
     *         type: "static",
     *         data: [1, 2, 3, 4],
     *         deletable: false,
     *       }
     */
    @TableField(value = "json_config")
    private String jsonConfig;

    /**
     * 是否启用
     */
    @TableField(value = "enabled")
    private boolean enabled;

    @TableField(value = "last_updated_Time")
    private Timestamp lastUpdatedTime;

    @TableField(value = "created_time")
    private Timestamp createdTime;

    @TableField(value = "`condition`")
    private String condition;

    @TableField(value = "`note`")
    private String note;

    @TableField(value = "setting_type", jdbcType = JdbcType.TINYINT, javaType = true, typeHandler = EnumOrdinalTypeHandler.class)
    private MetaPageSettingType settingType;

    public MetaPageSettingEntity() {
        this.setCreatedTime(Timestamp.from(Instant.now()));
    }

    public MetaPageSettingEntity(String identity,MetaPageSettingType settingType) {
        this();
        this.setId(String.format("%s_%s", settingType.ordinal(), identity));
        this.setSettingType(settingType);
    }


    public void change(String name,
                       String note,
                       String identity,
                       String jsonConfig,
                       boolean enabled,
                        String condition
                       ) {
        this.setName(name);
        this.setEnabled(enabled);
        this.setNote(note);
        this.setIdentity(identity);
        this.setJsonConfig(jsonConfig);
        this.setCondition(condition);
        this.setLastUpdatedTime(Timestamp.from(Instant.now()));
    }
}
