/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.bcx.domains.entities;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.tenant.bcx.infrastructures.TenantEmployeeContext;
import com.bcxin.tenant.bcx.infrastructures.entities.Aggregate;
import com.bcxin.tenant.bcx.infrastructures.entities.EntityAbstract;
import com.bcxin.tenant.bcx.infrastructures.enums.MetaCreatorReferenceType;
import java.sql.Timestamp;
import org.apache.ibatis.type.EnumOrdinalTypeHandler;
import org.apache.ibatis.type.JdbcType;

@TableName(value="meta_modules", autoResultMap=true)
public class MetaModuleEntity
extends EntityAbstract
implements Aggregate {
    @TableId(value="id")
    private String id;
    @TableField(value="name")
    private String name;
    @TableField(value="project_id")
    private String projectId;
    @TableField(value="reference_type", jdbcType=JdbcType.TINYINT, javaType=true, typeHandler=EnumOrdinalTypeHandler.class)
    private MetaCreatorReferenceType referenceType;
    @TableField(value="reference_number")
    private String referenceNumber;
    @TableField(value="creator_id")
    private String creatorId;
    @TableField(value="last_updater_id")
    private String lastUpdaterId;
    @TableField(value="deleted")
    private boolean deleted;
    @TableField(value="last_updated_Time")
    private Timestamp lastUpdatedTime;
    @TableField(value="created_time")
    private Timestamp createdTime;

    public static MetaModuleEntity create(String id, String projectId, String name, MetaCreatorReferenceType referenceType, String referenceNumber, String creatorId) {
        MetaModuleEntity entity = new MetaModuleEntity();
        entity.id = id;
        entity.projectId = projectId;
        entity.name = name;
        entity.referenceType = referenceType;
        entity.referenceNumber = referenceNumber;
        entity.creatorId = creatorId;
        entity.deleted = false;
        return entity;
    }

    public void change(String name, TenantEmployeeContext.TenantUserModel userModel) {
        this.name = name;
        this.lastUpdaterId = userModel.getId();
        this.lastUpdatedTime = new Timestamp(System.currentTimeMillis());
    }

    public void changeMarkAsDeleted(TenantEmployeeContext.TenantUserModel userModel) {
        this.deleted = true;
        this.lastUpdaterId = userModel.getId();
        this.lastUpdatedTime = new Timestamp(System.currentTimeMillis());
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public MetaCreatorReferenceType getReferenceType() {
        return this.referenceType;
    }

    public String getReferenceNumber() {
        return this.referenceNumber;
    }

    public String getCreatorId() {
        return this.creatorId;
    }

    public String getLastUpdaterId() {
        return this.lastUpdaterId;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public Timestamp getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public Timestamp getCreatedTime() {
        return this.createdTime;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public void setReferenceType(MetaCreatorReferenceType referenceType) {
        this.referenceType = referenceType;
    }

    public void setReferenceNumber(String referenceNumber) {
        this.referenceNumber = referenceNumber;
    }

    public void setCreatorId(String creatorId) {
        this.creatorId = creatorId;
    }

    public void setLastUpdaterId(String lastUpdaterId) {
        this.lastUpdaterId = lastUpdaterId;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public void setLastUpdatedTime(Timestamp lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
    }

    public void setCreatedTime(Timestamp createdTime) {
        this.createdTime = createdTime;
    }

    public String toString() {
        return "MetaModuleEntity(id=" + this.getId() + ", name=" + this.getName() + ", projectId=" + this.getProjectId() + ", referenceType=" + this.getReferenceType() + ", referenceNumber=" + this.getReferenceNumber() + ", creatorId=" + this.getCreatorId() + ", lastUpdaterId=" + this.getLastUpdaterId() + ", deleted=" + this.isDeleted() + ", lastUpdatedTime=" + this.getLastUpdatedTime() + ", createdTime=" + this.getCreatedTime() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetaModuleEntity)) {
            return false;
        }
        MetaModuleEntity other = (MetaModuleEntity)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isDeleted() != other.isDeleted()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$projectId = this.getProjectId();
        String other$projectId = other.getProjectId();
        if (this$projectId == null ? other$projectId != null : !this$projectId.equals(other$projectId)) {
            return false;
        }
        MetaCreatorReferenceType this$referenceType = this.getReferenceType();
        MetaCreatorReferenceType other$referenceType = other.getReferenceType();
        if (this$referenceType == null ? other$referenceType != null : !this$referenceType.equals(other$referenceType)) {
            return false;
        }
        String this$referenceNumber = this.getReferenceNumber();
        String other$referenceNumber = other.getReferenceNumber();
        if (this$referenceNumber == null ? other$referenceNumber != null : !this$referenceNumber.equals(other$referenceNumber)) {
            return false;
        }
        String this$creatorId = this.getCreatorId();
        String other$creatorId = other.getCreatorId();
        if (this$creatorId == null ? other$creatorId != null : !this$creatorId.equals(other$creatorId)) {
            return false;
        }
        String this$lastUpdaterId = this.getLastUpdaterId();
        String other$lastUpdaterId = other.getLastUpdaterId();
        if (this$lastUpdaterId == null ? other$lastUpdaterId != null : !this$lastUpdaterId.equals(other$lastUpdaterId)) {
            return false;
        }
        Timestamp this$lastUpdatedTime = this.getLastUpdatedTime();
        Timestamp other$lastUpdatedTime = other.getLastUpdatedTime();
        if (this$lastUpdatedTime == null ? other$lastUpdatedTime != null : !((Object)this$lastUpdatedTime).equals(other$lastUpdatedTime)) {
            return false;
        }
        Timestamp this$createdTime = this.getCreatedTime();
        Timestamp other$createdTime = other.getCreatedTime();
        return !(this$createdTime == null ? other$createdTime != null : !((Object)this$createdTime).equals(other$createdTime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MetaModuleEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDeleted() ? 79 : 97);
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $projectId = this.getProjectId();
        result = result * 59 + ($projectId == null ? 43 : $projectId.hashCode());
        MetaCreatorReferenceType $referenceType = this.getReferenceType();
        result = result * 59 + ($referenceType == null ? 43 : $referenceType.hashCode());
        String $referenceNumber = this.getReferenceNumber();
        result = result * 59 + ($referenceNumber == null ? 43 : $referenceNumber.hashCode());
        String $creatorId = this.getCreatorId();
        result = result * 59 + ($creatorId == null ? 43 : $creatorId.hashCode());
        String $lastUpdaterId = this.getLastUpdaterId();
        result = result * 59 + ($lastUpdaterId == null ? 43 : $lastUpdaterId.hashCode());
        Timestamp $lastUpdatedTime = this.getLastUpdatedTime();
        result = result * 59 + ($lastUpdatedTime == null ? 43 : ((Object)$lastUpdatedTime).hashCode());
        Timestamp $createdTime = this.getCreatedTime();
        result = result * 59 + ($createdTime == null ? 43 : ((Object)$createdTime).hashCode());
        return result;
    }
}

