/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.bcx.domains.criterias;

import com.bcxin.tenant.bcx.infrastructures.criterias.CriteriaAbstract;
import com.bcxin.tenant.bcx.infrastructures.valueTypes.DynamicConditionFieldValueType;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.springframework.util.CollectionUtils;

public class DynamicPageDataCriteria
extends CriteriaAbstract {
    private final boolean forMappingQuery;
    private final String pageId;
    private final Collection<DynamicConditionFieldValueType> fields;

    protected DynamicPageDataCriteria(int pageIndex, int pageSize, boolean forMappingQuery, String pageId, Collection<DynamicConditionFieldValueType> fields) {
        super(pageIndex, pageSize);
        this.pageId = pageId;
        this.fields = fields;
        this.forMappingQuery = forMappingQuery;
    }

    public static DynamicPageDataCriteria create(int pageIndex, int pageSize, boolean forMappingQuery, String pageId, Collection<DynamicConditionFieldValueType> fields) {
        return new DynamicPageDataCriteria(pageIndex, pageSize, forMappingQuery, pageId, fields);
    }

    public Map<String, Object> getFiledKeyValueMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (!CollectionUtils.isEmpty(this.fields)) {
            for (DynamicConditionFieldValueType fieldValueType : this.fields) {
                map.put(fieldValueType.getField(), fieldValueType.getValue());
            }
        }
        return map;
    }

    public boolean isForMappingQuery() {
        return this.forMappingQuery;
    }

    public String getPageId() {
        return this.pageId;
    }

    public Collection<DynamicConditionFieldValueType> getFields() {
        return this.fields;
    }
}

