/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.bcx.domains.services.impls;

import com.bcxin.tenant.bcx.domains.entities.AnalyticsLogEntity;
import com.bcxin.tenant.bcx.domains.repositories.AnalyticsLogRepository;
import com.bcxin.tenant.bcx.domains.services.AnalyticsLogService;
import com.bcxin.tenant.bcx.domains.services.commands.CreateAnalyticsLogCommand;
import com.bcxin.tenant.bcx.infrastructures.UnitWork;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AnalyticsLogServiceImpl
implements AnalyticsLogService {
    Logger logger = LoggerFactory.getLogger(AnalyticsLogServiceImpl.class);
    private final UnitWork unitWork;
    private final AnalyticsLogRepository analyticsLogRepository;

    public AnalyticsLogServiceImpl(UnitWork unitWork, AnalyticsLogRepository analyticsLogRepository) {
        this.unitWork = unitWork;
        this.analyticsLogRepository = analyticsLogRepository;
    }

    @Override
    public void dispatch(CreateAnalyticsLogCommand command) {
        Collection<AnalyticsLogEntity> analyticsLogs = command.getAnalyticsLogs();
        String transactionId = this.unitWork.beginTransaction();
        try {
            this.analyticsLogRepository.batchInsert(analyticsLogs);
            this.unitWork.commit(transactionId);
        }
        catch (Exception e) {
            this.logger.error("\u6dfb\u52a0AnalyticsLog\u8bb0\u5f55\u65f6\u53d1\u751f\u5f02\u5e38\uff1a{}", (Throwable)e);
            this.unitWork.rollback(transactionId);
            throw e;
        }
    }
}

