/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.bcx.domains.entities;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.tenant.bcx.infrastructures.TenantEmployeeContext;
import com.bcxin.tenant.bcx.infrastructures.entities.Aggregate;
import com.bcxin.tenant.bcx.infrastructures.entities.EntityAbstract;
import com.bcxin.tenant.bcx.infrastructures.enums.MetaCreatorReferenceType;
import java.sql.Timestamp;
import org.apache.ibatis.type.EnumOrdinalTypeHandler;
import org.apache.ibatis.type.JdbcType;

@TableName(value="bus_organ_registry_forms", autoResultMap=true)
public class BusOrganRegistryFormsEntity
extends EntityAbstract
implements Aggregate {
    @TableId(value="id")
    private String id;
    @TableField(value="institutional_type_code")
    private String institutionalTypeCode;
    @TableField(value="industry_type_code")
    private String industryTypeCode;
    @TableField(value="region_code")
    private String regionCode;
    @TableField(value="page_id")
    private String pageId;
    @TableField(value="reference_type", jdbcType=JdbcType.TINYINT, javaType=true, typeHandler=EnumOrdinalTypeHandler.class)
    private MetaCreatorReferenceType referenceType;
    @TableField(value="reference_number")
    private String referenceNumber;
    @TableField(value="creator_id")
    private String creatorId;
    @TableField(value="last_updater_id")
    private String lastUpdaterId;
    @TableField(value="last_updated_time")
    private Timestamp lastUpdatedTime;
    @TableField(value="created_time")
    private Timestamp createdTime;
    @TableField(value="deleted")
    private boolean deleted;

    public void markAsDeleted() {
        this.deleted = true;
    }

    public void change(String institutionalTypeCode, String industryTypeCode, String regionCode, MetaCreatorReferenceType referenceType, String referenceNumber, String lastUpdaterId) {
        if (institutionalTypeCode != null) {
            this.institutionalTypeCode = institutionalTypeCode;
        }
        if (industryTypeCode != null) {
            this.industryTypeCode = industryTypeCode;
        }
        if (regionCode != null) {
            this.regionCode = regionCode;
        }
        if (referenceType != null) {
            this.referenceType = referenceType;
        }
        if (referenceNumber != null) {
            this.referenceNumber = referenceNumber;
        }
        this.lastUpdaterId = lastUpdaterId;
        this.lastUpdatedTime = new Timestamp(System.currentTimeMillis());
    }

    public void changeMarkAsDeleted(TenantEmployeeContext.TenantUserModel userModel) {
        this.deleted = true;
        this.setLastUpdaterId(userModel.getId());
        this.setLastUpdatedTime(new Timestamp(System.currentTimeMillis()));
    }

    public static BusOrganRegistryFormsEntity create(String id, String institutionalTypeCode, String industryTypeCode, String regionCode, String pageId, MetaCreatorReferenceType referenceType, String referenceNumber, String creatorId) {
        BusOrganRegistryFormsEntity entity = new BusOrganRegistryFormsEntity();
        entity.setId(id);
        entity.setInstitutionalTypeCode(institutionalTypeCode);
        entity.setIndustryTypeCode(industryTypeCode);
        entity.setRegionCode(regionCode);
        entity.setPageId(pageId);
        entity.setReferenceType(referenceType);
        entity.setReferenceNumber(referenceNumber);
        entity.setCreatorId(creatorId);
        entity.setDeleted(false);
        Timestamp now = new Timestamp(System.currentTimeMillis());
        entity.setCreatedTime(now);
        entity.setLastUpdatedTime(now);
        return entity;
    }

    public String getId() {
        return this.id;
    }

    public String getInstitutionalTypeCode() {
        return this.institutionalTypeCode;
    }

    public String getIndustryTypeCode() {
        return this.industryTypeCode;
    }

    public String getRegionCode() {
        return this.regionCode;
    }

    public String getPageId() {
        return this.pageId;
    }

    public MetaCreatorReferenceType getReferenceType() {
        return this.referenceType;
    }

    public String getReferenceNumber() {
        return this.referenceNumber;
    }

    public String getCreatorId() {
        return this.creatorId;
    }

    public String getLastUpdaterId() {
        return this.lastUpdaterId;
    }

    public Timestamp getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public Timestamp getCreatedTime() {
        return this.createdTime;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setInstitutionalTypeCode(String institutionalTypeCode) {
        this.institutionalTypeCode = institutionalTypeCode;
    }

    public void setIndustryTypeCode(String industryTypeCode) {
        this.industryTypeCode = industryTypeCode;
    }

    public void setRegionCode(String regionCode) {
        this.regionCode = regionCode;
    }

    public void setPageId(String pageId) {
        this.pageId = pageId;
    }

    public void setReferenceType(MetaCreatorReferenceType referenceType) {
        this.referenceType = referenceType;
    }

    public void setReferenceNumber(String referenceNumber) {
        this.referenceNumber = referenceNumber;
    }

    public void setCreatorId(String creatorId) {
        this.creatorId = creatorId;
    }

    public void setLastUpdaterId(String lastUpdaterId) {
        this.lastUpdaterId = lastUpdaterId;
    }

    public void setLastUpdatedTime(Timestamp lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
    }

    public void setCreatedTime(Timestamp createdTime) {
        this.createdTime = createdTime;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public String toString() {
        return "BusOrganRegistryFormsEntity(id=" + this.getId() + ", institutionalTypeCode=" + this.getInstitutionalTypeCode() + ", industryTypeCode=" + this.getIndustryTypeCode() + ", regionCode=" + this.getRegionCode() + ", pageId=" + this.getPageId() + ", referenceType=" + this.getReferenceType() + ", referenceNumber=" + this.getReferenceNumber() + ", creatorId=" + this.getCreatorId() + ", lastUpdaterId=" + this.getLastUpdaterId() + ", lastUpdatedTime=" + this.getLastUpdatedTime() + ", createdTime=" + this.getCreatedTime() + ", deleted=" + this.isDeleted() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BusOrganRegistryFormsEntity)) {
            return false;
        }
        BusOrganRegistryFormsEntity other = (BusOrganRegistryFormsEntity)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isDeleted() != other.isDeleted()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$institutionalTypeCode = this.getInstitutionalTypeCode();
        String other$institutionalTypeCode = other.getInstitutionalTypeCode();
        if (this$institutionalTypeCode == null ? other$institutionalTypeCode != null : !this$institutionalTypeCode.equals(other$institutionalTypeCode)) {
            return false;
        }
        String this$industryTypeCode = this.getIndustryTypeCode();
        String other$industryTypeCode = other.getIndustryTypeCode();
        if (this$industryTypeCode == null ? other$industryTypeCode != null : !this$industryTypeCode.equals(other$industryTypeCode)) {
            return false;
        }
        String this$regionCode = this.getRegionCode();
        String other$regionCode = other.getRegionCode();
        if (this$regionCode == null ? other$regionCode != null : !this$regionCode.equals(other$regionCode)) {
            return false;
        }
        String this$pageId = this.getPageId();
        String other$pageId = other.getPageId();
        if (this$pageId == null ? other$pageId != null : !this$pageId.equals(other$pageId)) {
            return false;
        }
        MetaCreatorReferenceType this$referenceType = this.getReferenceType();
        MetaCreatorReferenceType other$referenceType = other.getReferenceType();
        if (this$referenceType == null ? other$referenceType != null : !this$referenceType.equals(other$referenceType)) {
            return false;
        }
        String this$referenceNumber = this.getReferenceNumber();
        String other$referenceNumber = other.getReferenceNumber();
        if (this$referenceNumber == null ? other$referenceNumber != null : !this$referenceNumber.equals(other$referenceNumber)) {
            return false;
        }
        String this$creatorId = this.getCreatorId();
        String other$creatorId = other.getCreatorId();
        if (this$creatorId == null ? other$creatorId != null : !this$creatorId.equals(other$creatorId)) {
            return false;
        }
        String this$lastUpdaterId = this.getLastUpdaterId();
        String other$lastUpdaterId = other.getLastUpdaterId();
        if (this$lastUpdaterId == null ? other$lastUpdaterId != null : !this$lastUpdaterId.equals(other$lastUpdaterId)) {
            return false;
        }
        Timestamp this$lastUpdatedTime = this.getLastUpdatedTime();
        Timestamp other$lastUpdatedTime = other.getLastUpdatedTime();
        if (this$lastUpdatedTime == null ? other$lastUpdatedTime != null : !((Object)this$lastUpdatedTime).equals(other$lastUpdatedTime)) {
            return false;
        }
        Timestamp this$createdTime = this.getCreatedTime();
        Timestamp other$createdTime = other.getCreatedTime();
        return !(this$createdTime == null ? other$createdTime != null : !((Object)this$createdTime).equals(other$createdTime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BusOrganRegistryFormsEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDeleted() ? 79 : 97);
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $institutionalTypeCode = this.getInstitutionalTypeCode();
        result = result * 59 + ($institutionalTypeCode == null ? 43 : $institutionalTypeCode.hashCode());
        String $industryTypeCode = this.getIndustryTypeCode();
        result = result * 59 + ($industryTypeCode == null ? 43 : $industryTypeCode.hashCode());
        String $regionCode = this.getRegionCode();
        result = result * 59 + ($regionCode == null ? 43 : $regionCode.hashCode());
        String $pageId = this.getPageId();
        result = result * 59 + ($pageId == null ? 43 : $pageId.hashCode());
        MetaCreatorReferenceType $referenceType = this.getReferenceType();
        result = result * 59 + ($referenceType == null ? 43 : $referenceType.hashCode());
        String $referenceNumber = this.getReferenceNumber();
        result = result * 59 + ($referenceNumber == null ? 43 : $referenceNumber.hashCode());
        String $creatorId = this.getCreatorId();
        result = result * 59 + ($creatorId == null ? 43 : $creatorId.hashCode());
        String $lastUpdaterId = this.getLastUpdaterId();
        result = result * 59 + ($lastUpdaterId == null ? 43 : $lastUpdaterId.hashCode());
        Timestamp $lastUpdatedTime = this.getLastUpdatedTime();
        result = result * 59 + ($lastUpdatedTime == null ? 43 : ((Object)$lastUpdatedTime).hashCode());
        Timestamp $createdTime = this.getCreatedTime();
        result = result * 59 + ($createdTime == null ? 43 : ((Object)$createdTime).hashCode());
        return result;
    }
}

