/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.bcx.domains.criterias;

import com.bcxin.tenant.bcx.infrastructures.criterias.CriteriaAbstract;
import com.bcxin.tenant.bcx.infrastructures.valueTypes.DynamicConditionFieldValueType;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.springframework.util.CollectionUtils;

public class DynamicPageDataCriteria
extends CriteriaAbstract {
    private final String pageId;
    private final String mappingId;
    private final Collection<DynamicConditionFieldValueType> fields;

    protected DynamicPageDataCriteria(int pageIndex, int pageSize, String pageId, String mappingId, Collection<DynamicConditionFieldValueType> fields) {
        super(pageIndex, pageSize);
        this.pageId = pageId;
        this.fields = fields;
        this.mappingId = mappingId;
    }

    public static DynamicPageDataCriteria create(int pageIndex, int pageSize, String pageId, Collection<DynamicConditionFieldValueType> fields) {
        return new DynamicPageDataCriteria(pageIndex, pageSize, pageId, null, fields);
    }

    public static DynamicPageDataCriteria createForMapping(int pageIndex, int pageSize, String mappingId, Collection<DynamicConditionFieldValueType> fields) {
        return new DynamicPageDataCriteria(pageIndex, pageSize, null, mappingId, fields);
    }

    public Map<String, Object> getFiledKeyValueMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (!CollectionUtils.isEmpty(this.fields)) {
            for (DynamicConditionFieldValueType fieldValueType : this.fields) {
                map.put(fieldValueType.getField(), fieldValueType.getValue());
            }
        }
        return map;
    }

    public String getPageId() {
        return this.pageId;
    }

    public String getMappingId() {
        return this.mappingId;
    }

    public Collection<DynamicConditionFieldValueType> getFields() {
        return this.fields;
    }
}

