package com.bcxin.tenant.bcx.domains.repositories;

import com.bcxin.tenant.bcx.domains.criterias.ExamEnrollmentCriteria;
import com.bcxin.tenant.bcx.domains.dtos.ExamEnrollmentCriteriaDTO;
import com.bcxin.tenant.bcx.domains.entities.ExamEnrollmentCriteriaEntity;
import com.bcxin.tenant.bcx.domains.mappers.ExamEnrollmentCriteriaMapper;
import com.bcxin.tenant.bcx.domains.mappers.MetaPageMapper;
import com.bcxin.tenant.bcx.infrastructures.EntityCollection;
import org.springframework.stereotype.Repository;

import java.util.Collection;

@Repository
public class ExamEnrollmentCriteriaRepositoryImpl
        extends RepositoryAbstract<ExamEnrollmentCriteriaEntity> implements ExamEnrollmentCriteriaRepository{
    private final ExamEnrollmentCriteriaMapper criteriaMapper;
    private final MetaPageRepository metaPageRepository;

    protected ExamEnrollmentCriteriaRepositoryImpl(ExamEnrollmentCriteriaMapper mapper,
                                                   MetaPageRepository metaPageRepository) {
        super(mapper);
        this.criteriaMapper = mapper;
        this.metaPageRepository = metaPageRepository;
    }

    @Override
    public void delete(ExamEnrollmentCriteriaEntity entity) {
        this.metaPageRepository.delete(entity.getId());
        this.mapper.deleteById(entity.getId());
    }

    @Override
    public ExamEnrollmentCriteriaDTO getDtoById(String id) {
        ExamEnrollmentCriteriaDTO dto = this.criteriaMapper.getDtoById(id);

        return dto;
    }

    @Override
    public EntityCollection<ExamEnrollmentCriteriaDTO> search(ExamEnrollmentCriteria criteria) {
        Collection<ExamEnrollmentCriteriaDTO> dtos = this.criteriaMapper.select(criteria);
        Long totalCount = this.criteriaMapper.getTotalCount(criteria);

        return EntityCollection.create(
                dtos,
                criteria.getPageSize(),
                totalCount
        );
    }
}
