package com.bcxin.tenant.bcx.domains.repositories;

import com.bcxin.tenant.bcx.domains.criterias.DynamicQueryCriteria;
import com.bcxin.tenant.bcx.domains.mappers.DynamicQueryMapper;
import com.bcxin.tenant.bcx.infrastructures.EntityCollection;
import org.springframework.stereotype.Repository;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

@Repository
public class DynamicQueryRepositoryImpl implements DynamicQueryRepository {

    private final DynamicQueryMapper dynamicQueryMapper;

    public DynamicQueryRepositoryImpl(DynamicQueryMapper dynamicQueryMapper) {
        this.dynamicQueryMapper = dynamicQueryMapper;
    }

    @Override
    public EntityCollection<Map<String, Object>> search(DynamicQueryCriteria criteria) {
        Map<String, Object> params = new HashMap<>();
        params.put("dsl", criteria.getDsl());
        params.put("params", criteria.getParams());
        params.put("advanceParams", criteria.getAdvanceParams());

        Collection<Map<String, Object>> data = this.dynamicQueryMapper.select(params);
        long count = this.dynamicQueryMapper.count(params);

        return EntityCollection.create(
                data,
                criteria.getPageSize(),
                count
        );
    }
}
