package com.bcxin.tenant.bcx.domains.repositories;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.bcxin.tenant.bcx.domains.entities.CommonDataSettingEntity;
import com.bcxin.tenant.bcx.domains.mappers.CommonDataSettingMapper;
import com.bcxin.tenant.bcx.infrastructures.EntityCollection;
import org.springframework.stereotype.Repository;

import java.util.Collection;
import java.util.List;

@Repository
public class CommonDataSettingRepositoryImpl implements CommonDataSettingRepository {
    private final CommonDataSettingMapper mapper;

    public CommonDataSettingRepositoryImpl(CommonDataSettingMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public CommonDataSettingEntity getById(Object id) {
        return this.mapper.selectById((String) id);
    }

    @Override
    public void insert(CommonDataSettingEntity data) {
        this.mapper.insert(data);
    }

    @Override
    public void update(CommonDataSettingEntity data) {
        this.mapper.updateById(data);
    }

    @Override
    public void delete(Object id) {

    }

    @Override
    public EntityCollection<CommonDataSettingEntity> search(int pageIndex, int pageSize) {
        return null;
    }

    @Override
    public Collection<CommonDataSettingEntity> getAll() {
        return List.of();
    }

    @Override
    public Collection<CommonDataSettingEntity> getMatchedSettings() {
        /**
         * todo: 后续会跟权限有关系
         */
        LambdaQueryWrapper<CommonDataSettingEntity> lambdaQueryWrapper = new LambdaQueryWrapper<>();

        return this.mapper.selectList(lambdaQueryWrapper);
    }
}
