package com.bcxin.tenant.bcx.domains.plugins;

import com.bcxin.tenant.bcx.infrastructures.components.RetryProvider;
import com.bcxin.tenant.bcx.infrastructures.exceptions.BadTenantException;
import com.bcxin.tenant.bcx.infrastructures.exceptions.IgnoreTenantException;
import com.bcxin.tenant.bcx.infrastructures.utils.ExceptionUtil;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Signature;

import java.sql.SQLIntegrityConstraintViolationException;

@Intercepts({
        @Signature(type = Executor.class,method = "update",args = {MappedStatement.class,Object.class})
})
public class MybatisExecuteBatisPlugin implements Interceptor {
    private final RetryProvider retryProvider;

    public MybatisExecuteBatisPlugin(RetryProvider retryProvider) {
        this.retryProvider = retryProvider;
    }


    @Override
    public Object intercept(Invocation invocation) throws Throwable {

        return retryProvider.doExecute(() -> {
            try {
                return invocation.proceed();
            } catch (Exception e) {
                if (e.getCause() != null && e.getCause().getClass().isAssignableFrom(SQLIntegrityConstraintViolationException.class)) {
                    throw new IgnoreTenantException("Mybatis执行异常", e);
                }

                if (ExceptionUtil.getStackMessage(e).contains("Duplicate entry")) {
                    throw new IgnoreTenantException("Mybatis执行异常", e);
                }

                throw new BadTenantException(e.getMessage(), e);
            }
        });
    }
}
