package com.bcxin.tenant.bcx.domains.mappers;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.bcxin.tenant.bcx.domains.entities.MetaPageVersionEntity;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 页面版本Mapper接口
 */
@Mapper
public interface MetaPageVersionMapper extends BaseMapper<MetaPageVersionEntity> {
    
    @Select("SELECT * FROM meta_page_versions WHERE page_id = #{pageId} ORDER BY version DESC")
    List<MetaPageVersionEntity> selectByPageId(@Param("pageId") String pageId);
    
    @Select("SELECT * FROM meta_page_versions WHERE page_id = #{pageId} AND version = #{version}")
    MetaPageVersionEntity selectByPageIdAndVersion(@Param("pageId") String pageId, @Param("version") long version);
}

