/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.bcx.domains.repositories;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bcxin.tenant.bcx.infrastructures.EntityCollection;
import com.bcxin.tenant.bcx.infrastructures.entities.Aggregate;
import com.bcxin.tenant.bcx.infrastructures.repositories.RepositoryBase;
import java.io.Serializable;
import java.util.Collection;

public abstract class RepositoryAbstract<T extends Aggregate>
implements RepositoryBase<T> {
    protected final BaseMapper<T> mapper;

    protected RepositoryAbstract(BaseMapper<T> mapper) {
        this.mapper = mapper;
    }

    public T getById(Object id) {
        return (T)((Aggregate)this.mapper.selectById((Serializable)id));
    }

    public void insert(T data) {
        this.mapper.insert(data);
    }

    public void update(T data) {
        this.mapper.updateById(data);
    }

    public void delete(Object id) {
        this.mapper.deleteById((Serializable)id);
    }

    public EntityCollection<T> search(int pageIndex, int pageSize) {
        Page page = new Page((long)pageIndex, (long)pageSize);
        Page result = (Page)this.mapper.selectPage((IPage)page, null);
        return EntityCollection.create((Collection)result.getRecords(), (int)pageSize, (Long)result.getTotal());
    }

    public Collection<T> getAll() {
        return this.mapper.selectList(null);
    }
}

