/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.bcx.domains.plugins;

import com.bcxin.tenant.bcx.infrastructures.components.RetryProvider;
import com.bcxin.tenant.bcx.infrastructures.exceptions.BadTenantException;
import com.bcxin.tenant.bcx.infrastructures.exceptions.IgnoreTenantException;
import com.bcxin.tenant.bcx.infrastructures.exceptions.RetryableTenantException;
import com.bcxin.tenant.bcx.infrastructures.utils.ExceptionUtil;
import com.mysql.cj.jdbc.exceptions.CommunicationsException;
import java.sql.SQLIntegrityConstraintViolationException;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Signature;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class MybatisExecuteBatisPlugin
implements Interceptor {
    private final RetryProvider retryProvider;

    public MybatisExecuteBatisPlugin(RetryProvider retryProvider) {
        this.retryProvider = retryProvider;
    }

    public Object intercept(Invocation invocation) throws Throwable {
        return this.retryProvider.doExecute(() -> {
            try {
                return invocation.proceed();
            }
            catch (Exception e) {
                String detail;
                if (e.getCause() != null) {
                    Class<SQLIntegrityConstraintViolationException> tClass = e.getCause().getClass();
                    if (tClass.isAssignableFrom(SQLIntegrityConstraintViolationException.class)) {
                        throw new IgnoreTenantException("Mybatis\u6267\u884c\u5f02\u5e38", e);
                    }
                    if (tClass.isAssignableFrom(CommunicationsException.class)) {
                        throw new RetryableTenantException("\u7f51\u7edc\u5f02\u5e38, \u5373\u5c06\u91cd\u8bd5", e);
                    }
                }
                if ((detail = ExceptionUtil.getStackMessage((Throwable)e)).contains("Duplicate entry")) {
                    throw new IgnoreTenantException("\u91cd\u590d\u6570\u636e\u63d0\u4ea4\u5f02\u5e38", e);
                }
                if (detail.contains("SQLSyntaxErrorException")) {
                    throw new IgnoreTenantException("SQL\u811a\u672c\u5f02\u5e38; \u8bf7\u68c0\u67e5\u811a\u672c\u8bed\u53e5", e);
                }
                throw new BadTenantException(e.getMessage(), (Throwable)e);
            }
        });
    }
}

