package com.bcxin.tenant.bcx.backend.tasks.configs;

import com.bcxin.tenant.bcx.backend.tasks.properties.RtcDeviceProperty;
import com.bcxin.tenant.bcx.dubbo.common.configs.DubboConfigProperty;
import org.apache.dubbo.config.ConsumerConfig;
import org.apache.dubbo.config.spring.context.annotation.EnableDubbo;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@EnableDubbo(scanBasePackages = "com.bcxin.tenant.open.backend.tasks.impls")
@ComponentScan(basePackages = "com.bcxin.tenant")
@Configuration
@EnableConfigurationProperties(RtcDeviceProperty.class)
public class DubboConfig {
    public DubboConfig() {

    }

    @Bean
    public ConsumerConfig registryConfig(DubboConfigProperty property) {
        ConsumerConfig config = new ConsumerConfig();
        config.setCheck(false);
        /**
         * 不过期
         */
        config.setTimeout(120 * 1000);
        /**
         * 禁用重试
         */
        config.setRetries(0);
        config.setVersion(property.getVersion());
        config.setCheck(false);

        return config;
    }
}
