package com.bcxin.tenant.bcx.backend.tasks.rings.components;

import com.bcxin.tenant.bcx.backend.tasks.rings.vos.RefreshOrganizationVo;
import com.bcxin.tenant.bcx.backend.tasks.rings.vos.RefreshProjectVo;
import com.bcxin.tenant.bcx.infrastructures.events.ObjectEvent;
import com.lmax.disruptor.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

@Component
public class ProcessingEventHandler implements EventHandler<ObjectEvent> {
    private final static Logger logger = LoggerFactory.getLogger(ProcessingEventHandler.class);
    private final static Collection<ObjectEvent> _pendingEvents = new ArrayList<>();


    public ProcessingEventHandler() {
        Executors.newScheduledThreadPool(1).scheduleAtFixedRate(this::executeProcessingEvent, 60, 60, TimeUnit.SECONDS);
    }

    @Override
    public void onEvent(ObjectEvent event, long sequence, boolean endOfBatch) throws Exception {
        _pendingEvents.add(event);
    }

    private void executeProcessingEvent() {
        if (_pendingEvents.size() == 0) {
            return;
        }
        var toProcessedEvents = new ArrayList<>(_pendingEvents);
        try {
            var organizationIds = toProcessedEvents.stream()
                    .filter(ii -> ii.getData() instanceof RefreshOrganizationVo)
                    .map(ii -> (RefreshOrganizationVo) ii.getData()).filter(ii -> ii != null)
                    .flatMap(ii -> ii.getOrganizationIds().stream())
                    .collect(Collectors.toSet());



            var projectIds = toProcessedEvents.stream()
                    .filter(ii -> ii.getData() instanceof RefreshProjectVo)
                    .map(ii -> (RefreshProjectVo) ii.getData()).filter(ii -> ii != null)
                    .flatMap(ii -> ii.getProjectIds().stream())
                    .collect(Collectors.toSet());


        } finally {
            _pendingEvents.removeAll(toProcessedEvents);
        }
    }
}
