package com.bcxin.tenant.bcx.backend.tasks.configs;

import com.bcxin.tenant.bcx.infrastructures.utils.ExceptionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.util.CollectionUtils;

import java.util.Calendar;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

@Configuration
@EnableScheduling
public class ScheduleConfig  implements BeanFactoryAware {
    private static final Logger logger = LoggerFactory.getLogger(ScheduleConfig.class);
    private static final int SCHEDULE_PAGE_SIZE = 800;

    private BeanFactory beanFactory;

    @Override
    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    /**
     * 仅在22点到7点之间执行
     *
     * @return
     */
    private boolean isAllowed() {
        int hour = Calendar.getInstance().get(Calendar.HOUR_OF_DAY);

        return hour >= 22 || hour <= 7;
    }

    private void executeDoubleCheckFlow(
            Function<Integer,Collection<String>> extractIds,
            Consumer<Collection<String>> consumer, String caption) {
        logger.error("begin to auto refresh {}", caption);

        Collection<String> ids = extractIds.apply(0);
        long totalCount = ids.size();
        /**
         * 每次请求; 刷新检查最多100万次
         */
        for (int index = 1; index <= 2000; index++) {
            if (!isAllowed()) {
                logger.error("not allow to auto refresh company");
                return;
            }

            if (!CollectionUtils.isEmpty(ids)) {
                try {
                    consumer.accept(ids);
                    logger.error("double refresh {} with size={}", caption, ids.size());
                } catch (Exception ex) {
                    logger.error("update {} (pageIndex={})发生异常:{},ids={}, 异常={}",
                            caption,
                            index, ids.stream().collect(Collectors.joining(",")),
                            ExceptionUtil.getStackMessage(ex));
                    ex.printStackTrace();
                } finally {
                    /**
                     * 如果数量小于页码, 则直接跳出
                     */
                    if (ids.size() < SCHEDULE_PAGE_SIZE) {
                        ids.clear();
                        break;
                    }
                    ids.clear();
                }

                ids = extractIds.apply(index);
                totalCount += ids.size();
            } else {
                break;
            }
        }

        logger.error("refresh the {} status-total count-{}", caption, totalCount);
    }
}