package com.bcxin.backend.certificateSignatures.impls;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.backend.certificateSignatures.CertificateConfigProperty;
import com.bcxin.backend.certificateSignatures.CertificateSignatureProvider;
import com.bcxin.backend.domain.repositories.SignatureQueuesRepository;
import com.bcxin.backend.domain.services.impls.ConvertServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;

@Component
@Qualifier("beijing")
public class CertificateSignatureProvider_Beijing extends CertificateSignatureProviderAbstract
        implements CertificateSignatureProvider {
    private static final Logger logger = LoggerFactory.getLogger(CertificateSignatureProvider_Beijing.class);

    public CertificateSignatureProvider_Beijing(CertificateConfigProperty configProperty,
                                                SignatureQueuesRepository signatureQueuesRepository,
                                                @Qualifier("primaryJdbcTemplate") JdbcTemplate jdbcTemplate,
                                                ConvertServiceImpl convertService) {
        super(configProperty, signatureQueuesRepository, jdbcTemplate, convertService);
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

    /**
     * 执行电子签章操作
     * @return
     */
    @Override
    protected boolean activateXMPSignQuicklyExCGI() {
        String cgiApi = configProperty.getCgiApi();
        try {
            JSONObject json = new JSONObject();

            json.put("service", "wss://127.0.0.1:8800");
            json.put("sn", "2171101001009256");
            json.put("pin", "88888888");
            /**
             * ?这边的/data/share/in 与上一步的temp=>复制到in的关联关系是什么
             */
            json.put("in", "/data/share/in");
            json.put("out", "/data/share/out");
            JSONArray arr = new JSONArray();
            JSONObject pos = new JSONObject();
            pos.put("centerX", 405);
            pos.put("centerY", 312);
            pos.put("page", 1);
            arr.add(pos);
            json.put("signOnPos", arr);
            String ret = HttpUtil.post(cgiApi, json.toJSONString());
            getLogger().info("====> 电子签章定时任务开始.activateXMPSignQuicklyExCGI.ret：{}", ret);
            if (StringUtils.isEmpty(ret)) {
                return false;
            }

            JSONObject result = JSON.parseObject(ret.replace("#", ""));
            if ("1".equals(String.valueOf(result.get("code")))) {
                return true;
            }

            return false;
        } catch (Exception e) {
            getLogger().error("====> 电子签章定时任务开始.activateXMPSignQuicklyExCGI message:", e);
        }

        return false;
    }
}
